/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.batch.WorkCenterDataServiceBatch;

/**
 * <p>
 *
 * This service is based on OData protocol and can be consumed in Fiori apps and on other user interfaces. It enables
 * you to create, read and update work centers. The service contains work center header, work center description, cost
 * center allocation, capacity assignment, capacity header, capacity description, capacity intervals, capacity shifts,
 * queuing operations, today’s operation, capacity per bucket and capacity order per bucket..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/62/ec4758c3f90a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WORK_CENTERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WORK_CENTERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Work Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface WorkCenterDataService extends BatchService<WorkCenterDataServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WORK_CENTERS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WorkCenterDataService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     * WorkCenterAllCapacity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     *         WorkCenterAllCapacity} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacityFluentHelper getAllWorkCenterAllCapacity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     * WorkCenterAllCapacity} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     *         WorkCenterAllCapacity} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacityByKeyFluentHelper getWorkCenterAllCapacityByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityInternalID,
        final String capacityCategoryAllocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     * WorkCenterAllCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     *            WorkCenterAllCapacity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     *         WorkCenterAllCapacity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacityCreateFluentHelper
        createWorkCenterAllCapacity( @Nonnull final WorkCenterAllCapacity workCenterAllCapacity );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *         WorkCenterAllCapacity_2} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacity_2FluentHelper getAllWorkCenterAllCapacity_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity using key fields.
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *         WorkCenterAllCapacity_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacity_2ByKeyFluentHelper getWorkCenterAllCapacity_2ByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *            WorkCenterAllCapacity_2} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *         WorkCenterAllCapacity_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2CreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacity_2CreateFluentHelper
        createWorkCenterAllCapacity_2( @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *            WorkCenterAllCapacity_2} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *         WorkCenterAllCapacity_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterAllCapacity_2UpdateFluentHelper
        updateWorkCenterAllCapacity_2( @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *         WorkCenterCapacity} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityFluentHelper getAllWorkCenterCapacity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *         WorkCenterCapacity} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityByKeyFluentHelper getWorkCenterCapacityByKey( final String capacityInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *            WorkCenterCapacity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *         WorkCenterCapacity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityCreateFluentHelper
        createWorkCenterCapacity( @Nonnull final WorkCenterCapacity workCenterCapacity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *            WorkCenterCapacity} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *         WorkCenterCapacity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityUpdateFluentHelper
        updateWorkCenterCapacity( @Nonnull final WorkCenterCapacity workCenterCapacity );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *         WorkCenterCapacityInterval} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityIntervalFluentHelper getAllWorkCenterCapacityInterval();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param intervalEndDate
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityActiveVersion
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *         WorkCenterCapacityInterval} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityIntervalByKeyFluentHelper getWorkCenterCapacityIntervalByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *            WorkCenterCapacityInterval} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *         WorkCenterCapacityInterval} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityIntervalCreateFluentHelper
        createWorkCenterCapacityInterval( @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *            WorkCenterCapacityInterval} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *         WorkCenterCapacityInterval} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityIntervalUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityIntervalUpdateFluentHelper
        updateWorkCenterCapacityInterval( @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *         WorkCenterCapacityInterval_2} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityInterval_2FluentHelper getAllWorkCenterCapacityInterval_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param intervalEndDate
     *
     * @param capacityActiveVersion
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *         WorkCenterCapacityInterval_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityInterval_2ByKeyFluentHelper getWorkCenterCapacityInterval_2ByKey(
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *            WorkCenterCapacityInterval_2} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *         WorkCenterCapacityInterval_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2CreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityInterval_2CreateFluentHelper
        createWorkCenterCapacityInterval_2( @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *            WorkCenterCapacityInterval_2} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *         WorkCenterCapacityInterval_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityInterval_2UpdateFluentHelper
        updateWorkCenterCapacityInterval_2( @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *         WorkCenterCapacityShift} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShiftFluentHelper getAllWorkCenterCapacityShift();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityCategoryAllocation
     *            Capacity allocation number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param intervalEndDate
     *
     * @param weekDay
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityActiveVersion
     *
     * @param availableCapacityShift
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *         WorkCenterCapacityShift} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShiftByKeyFluentHelper getWorkCenterCapacityShiftByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate,
        final String weekDay,
        final String availableCapacityShift );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *            WorkCenterCapacityShift} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *         WorkCenterCapacityShift} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShiftCreateFluentHelper
        createWorkCenterCapacityShift( @Nonnull final WorkCenterCapacityShift workCenterCapacityShift );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *            WorkCenterCapacityShift} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *         WorkCenterCapacityShift} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShiftUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShiftUpdateFluentHelper
        updateWorkCenterCapacityShift( @Nonnull final WorkCenterCapacityShift workCenterCapacityShift );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *         WorkCenterCapacityShift_2} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShift_2FluentHelper getAllWorkCenterCapacityShift_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param intervalEndDate
     *            Valid-to date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param weekDay
     *            Week Day
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param capacityActiveVersion
     *
     * @param availableCapacityShift
     *            Shift Number of an Available Capacity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *         WorkCenterCapacityShift_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShift_2ByKeyFluentHelper getWorkCenterCapacityShift_2ByKey(
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate,
        final String weekDay,
        final String availableCapacityShift );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *            WorkCenterCapacityShift_2} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *         WorkCenterCapacityShift_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2CreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShift_2CreateFluentHelper
        createWorkCenterCapacityShift_2( @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *            WorkCenterCapacityShift_2} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *         WorkCenterCapacityShift_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityShift_2UpdateFluentHelper
        updateWorkCenterCapacityShift_2( @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     * WorkCenterCapacityText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     *         WorkCenterCapacityText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityTextFluentHelper getAllWorkCenterCapacityText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     * WorkCenterCapacityText} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     *         WorkCenterCapacityText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityTextByKeyFluentHelper
        getWorkCenterCapacityTextByKey( final String capacityInternalID, final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     * WorkCenterCapacityText} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     *            WorkCenterCapacityText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     *         WorkCenterCapacityText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapacityTextUpdateFluentHelper
        updateWorkCenterCapacityText( @Nonnull final WorkCenterCapacityText workCenterCapacityText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp
     * WorkCenterCapDayOp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp
     *         WorkCenterCapDayOp} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapDayOpFluentHelper getAllWorkCenterCapDayOp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp
     * WorkCenterCapDayOp} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param orderID
     *
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param operation
     *            Operation/Activity Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenter
     *            Work Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mRPController
     *            MRP Controller for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp
     *         WorkCenterCapDayOp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapDayOpByKeyFluentHelper getWorkCenterCapDayOpByKey(
        final String plant,
        final String mRPController,
        final String workCenter,
        final String capacityInternalID,
        final String capacityRequirement,
        final String material,
        final String orderID,
        final String operation );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters
     * WorkCenterCapOrderPerBucketParameters} entity using key fields.
     *
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param p_CapEvalStartDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param p_CapEvalEndDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters
     *         WorkCenterCapOrderPerBucketParameters} entity using key fields. This fluent helper allows methods which
     *         modify the underlying query to be called before executing the query itself. To perform execution, call
     *         the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParametersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapOrderPerBucketParametersByKeyFluentHelper getWorkCenterCapOrderPerBucketParametersByKey(
        final LocalDateTime p_CapEvalStartDate,
        final LocalDateTime p_CapEvalEndDate,
        final String p_CapEvalBucketType );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters
     * WorkCenterCapPerBucketParameters} entity using key fields.
     *
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param p_CapEvalStartDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param p_CapEvalEndDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters
     *         WorkCenterCapPerBucketParameters} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParametersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapPerBucketParametersByKeyFluentHelper getWorkCenterCapPerBucketParametersByKey(
        final LocalDateTime p_CapEvalStartDate,
        final LocalDateTime p_CapEvalEndDate,
        final String p_CapEvalBucketType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp
     * WorkCenterCapPplineOp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp
     *         WorkCenterCapPplineOp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapPplineOpFluentHelper getAllWorkCenterCapPplineOp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp
     * WorkCenterCapPplineOp} entity using key fields.
     *
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param orderID
     *
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param operation
     *            Operation/Activity Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenter
     *            Work Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mRPController
     *            MRP Controller for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp
     *         WorkCenterCapPplineOp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCapPplineOpByKeyFluentHelper getWorkCenterCapPplineOpByKey(
        final String plant,
        final String mRPController,
        final String workCenter,
        final String capacityInternalID,
        final String capacityRequirement,
        final String material,
        final String orderID,
        final String operation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *         WorkCenterCostCenter} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCostCenterFluentHelper getAllWorkCenterCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entity using key fields.
     *
     * @param costCenterAllocation
     *            Cost Center Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param validityEndDate
     *            End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *         WorkCenterCostCenter} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCostCenterByKeyFluentHelper getWorkCenterCostCenterByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String costCenterAllocation,
        final LocalDateTime validityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entity and save it to the S/4HANA system.
     *
     * @param workCenterCostCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *            WorkCenterCostCenter} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *         WorkCenterCostCenter} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCostCenterCreateFluentHelper
        createWorkCenterCostCenter( @Nonnull final WorkCenterCostCenter workCenterCostCenter );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entity and save it to the S/4HANA system.
     *
     * @param workCenterCostCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *            WorkCenterCostCenter} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *         WorkCenterCostCenter} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenterUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterCostCenterUpdateFluentHelper
        updateWorkCenterCostCenter( @Nonnull final WorkCenterCostCenter workCenterCostCenter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation
     * WorkCenterDayOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation
     *         WorkCenterDayOperation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterDayOperationFluentHelper getAllWorkCenterDayOperation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation
     * WorkCenterDayOperation} entity using key fields.
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param workCenterInternalID
     *            Work Center Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperation
     *         WorkCenterDayOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDayOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterDayOperationByKeyFluentHelper getWorkCenterDayOperationByKey(
        final String workCenterInternalID,
        final String manufacturingOrder,
        final String manufacturingOrderOperation,
        final String manufacturingOrderCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     * WorkCenterDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     *         WorkCenterDescription} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterDescriptionFluentHelper getAllWorkCenterDescription();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     * WorkCenterDescription} entity using key fields.
     *
     * @param workCenterTypeCode
     *            Production Resource Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     *         WorkCenterDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterDescriptionByKeyFluentHelper getWorkCenterDescriptionByKey(
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     * WorkCenterDescription} entity and save it to the S/4HANA system.
     *
     * @param workCenterDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     *            WorkCenterDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     *         WorkCenterDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterDescriptionUpdateFluentHelper
        updateWorkCenterDescription( @Nonnull final WorkCenterDescription workCenterDescription );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
     * WorkCenterPipeLineOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
     *         WorkCenterPipeLineOperation} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterPipeLineOperationFluentHelper getAllWorkCenterPipeLineOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
     * WorkCenterPipeLineOperation} entity using key fields.
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param workCenterInternalID
     *            Work Center Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
     *         WorkCenterPipeLineOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCenterPipeLineOperationByKeyFluentHelper getWorkCenterPipeLineOperationByKey(
        final String workCenterInternalID,
        final String manufacturingOrder,
        final String manufacturingOrderOperation,
        final String manufacturingOrderCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCentersFluentHelper getAllWorkCenters();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     * entity using key fields.
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCentersByKeyFluentHelper
        getWorkCentersByKey( final String workCenterInternalID, final String workCenterTypeCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     * entity and save it to the S/4HANA system.
     *
     * @param workCenters
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCentersCreateFluentHelper createWorkCenters( @Nonnull final WorkCenters workCenters );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters
     * WorkCenters} entity and save it to the S/4HANA system.
     *
     * @param workCenters
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCentersUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkCentersUpdateFluentHelper updateWorkCenters( @Nonnull final WorkCenters workCenters );

}
