/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.batch.WorkforceAvailabilityServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the (CRUD) daily availability information into the
 * S/4HANA system from your external HR system when you are not using the SAP SuccessFactors Employee Central system.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b1/d0a7e300b244dda5f77890ba66ba82/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MANAGE_WF_AVAILABILITY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MANAGE_WF_AVAILABILITY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Employee Integration(SAP_COM_0001), External HR Workforce Integration(SAP_COM_0301), Employee Central via SAP CPI
 * Integration(SAP_COM_0535), Employee Central Integration(SAP_COM_1001)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central(JB1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FD'>Employee Integration - SAP S/4HANA Enablement(1FD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OFD'>Employee Integration - SAP S/4HANA Enablement(OFD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors Employee
 * Central(4AJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Workforce Person</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface WorkforceAvailabilityService extends BatchService<WorkforceAvailabilityServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/SHCM/API_MANAGE_WF_AVAILABILITY";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WorkforceAvailabilityService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *         TimeOverview} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeOverviewFluentHelper getAllTimeOverview();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity using key fields.
     *
     * @param personworkagreementexternalid
     *            Work Agreement Ext ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param companycode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param calendardate
     *            Calendar Date
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *         TimeOverview} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeOverviewByKeyFluentHelper getTimeOverviewByKey(
        final String personworkagreementexternalid,
        final String companycode,
        final LocalDateTime calendardate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity and save it to the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *         TimeOverview} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeOverviewCreateFluentHelper createTimeOverview( @Nonnull final TimeOverview timeOverview );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity and save it to the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *         TimeOverview} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeOverviewUpdateFluentHelper updateTimeOverview( @Nonnull final TimeOverview timeOverview );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     * TimeOverview} entity in the S/4HANA system.
     *
     * @param timeOverview
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *            TimeOverview} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverview
     *         TimeOverview} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforceavailability.TimeOverviewDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeOverviewDeleteFluentHelper deleteTimeOverview( @Nonnull final TimeOverview timeOverview );

}
