/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.batch.WorkforceTimesheetServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete (CRUD) data related to timesheet of a workforce
 * (Employees or Contingent Workers) with the data provided in a payload, in an API call. This service also supports
 * automatic posting of timesheet data to the controlling module synchronously.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fa/198e62c6d24788bd1f82082feb3096/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MANAGE_WORKFORCE_TIMESHEET?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MANAGE_WORKFORCE_TIMESHEET</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Workforce Timesheet Integration(SAP_COM_0027)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Q4'>Time Recording(1Q4)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J12'>Time Recording - Project-Based Services(J12)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OQ4'>Time Recording(OQ4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TimeSheet</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface WorkforceTimesheetService extends BatchService<WorkforceTimesheetServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MANAGE_WORKFORCE_TIMESHEET";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WorkforceTimesheetService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     * TimeSheetEntry} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     *         TimeSheetEntry} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeSheetEntryFluentHelper getAllTimeSheetEntry();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     * TimeSheetEntry} entity using key fields.
     *
     * @param personWorkAgreementExternalID
     *            Person Work Agreement External ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param timeSheetRecord
     *            Time Sheet Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     *         TimeSheetEntry} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeSheetEntryByKeyFluentHelper getTimeSheetEntryByKey(
        final String personWorkAgreementExternalID,
        final String companyCode,
        final String timeSheetRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     * TimeSheetEntry} entity and save it to the S/4HANA system.
     *
     * @param timeSheetEntry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     *            TimeSheetEntry} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntry
     *         TimeSheetEntry} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workforcetimesheet.TimeSheetEntryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TimeSheetEntryCreateFluentHelper createTimeSheetEntry( @Nonnull final TimeSheetEntry timeSheetEntry );

}
