/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class PostDifferencesFluentHelper
extends SingleValuedFluentHelperFunction<PostDifferencesFluentHelper, PhysInventoryDocHeader, PhysInventoryDocHeader> {
    private final Map<String, Object> values = Maps.newHashMap();

    public PostDifferencesFluentHelper(@Nonnull String servicePath, @Nullable BigDecimal postingThresholdValue, @Nullable LocalDateTime postingDate, @Nonnull String physicalInventoryDocument, @Nonnull String fiscalYear) {
        super(servicePath);
        if (postingThresholdValue != null) {
            this.values.put("PostingThresholdValue", postingThresholdValue);
        }
        if (postingDate != null) {
            this.values.put("PostingDate", postingDate);
        }
        this.values.put("PhysicalInventoryDocument", physicalInventoryDocument);
        this.values.put("FiscalYear", fiscalYear);
    }

    @Nonnull
    protected Class<PhysInventoryDocHeader> getEntityClass() {
        return PhysInventoryDocHeader.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "PostDifferences";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Nullable
    public PhysInventoryDocHeader executeRequest(@Nonnull HttpDestinationProperties destination) {
        return (PhysInventoryDocHeader)((Object)super.executeSingle(destination));
    }
}

