/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class PostDifferencesOnItemFluentHelper
extends SingleValuedFluentHelperFunction<PostDifferencesOnItemFluentHelper, PhysInventoryDocItem, PhysInventoryDocItem> {
    private final Map<String, Object> values = Maps.newHashMap();

    public PostDifferencesOnItemFluentHelper(@Nonnull String servicePath, @Nonnull String physicalInventoryDocumentItem, @Nonnull String material, @Nonnull String physicalInventoryDocument, @Nonnull String fiscalYear, @Nullable String batch, @Nullable String reasonForPhysInvtryDifference, @Nullable LocalDateTime postingDate) {
        super(servicePath);
        this.values.put("PhysicalInventoryDocumentItem", physicalInventoryDocumentItem);
        this.values.put("Material", material);
        this.values.put("PhysicalInventoryDocument", physicalInventoryDocument);
        this.values.put("FiscalYear", fiscalYear);
        if (batch != null) {
            this.values.put("Batch", batch);
        }
        if (reasonForPhysInvtryDifference != null) {
            this.values.put("ReasonForPhysInvtryDifference", reasonForPhysInvtryDifference);
        }
        if (postingDate != null) {
            this.values.put("PostingDate", postingDate);
        }
    }

    @Nonnull
    protected Class<PhysInventoryDocItem> getEntityClass() {
        return PhysInventoryDocItem.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "PostDifferencesOnItem";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Nullable
    public PhysInventoryDocItem executeRequest(@Nonnull HttpDestinationProperties destination) {
        return (PhysInventoryDocItem)((Object)super.executeSingle(destination));
    }
}

