/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class ConvertPlndOrderFluentHelper
extends SingleValuedFluentHelperFunction<ConvertPlndOrderFluentHelper, ProcessOrder, ProcessOrder> {
    private final Map<String, Object> values = Maps.newHashMap();

    public ConvertPlndOrderFluentHelper(@Nonnull String servicePath, @Nonnull String plannedOrder, @Nullable String manufacturingOrderType, @Nullable String manufacturingOrder) {
        super(servicePath);
        this.values.put("PlannedOrder", plannedOrder);
        if (manufacturingOrderType != null) {
            this.values.put("ManufacturingOrderType", manufacturingOrderType);
        }
        if (manufacturingOrder != null) {
            this.values.put("ManufacturingOrder", manufacturingOrder);
        }
    }

    @Nonnull
    protected Class<ProcessOrder> getEntityClass() {
        return ProcessOrder.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "ConvertPlndOrder";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Nullable
    public ProcessOrder executeRequest(@Nonnull HttpDestinationProperties destination) {
        return (ProcessOrder)((Object)super.executeSingle(destination));
    }
}

