/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity;

import java.util.Locale;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleAccessor;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;

import io.vavr.control.Option;

/**
 * Interface exposing the relevant fields used for an {@code HttpDestinationProperties} in an Erp context.
 */
public interface ErpHttpDestinationProperties extends HttpDestinationProperties
{
    /**
     * The default property key to retrieve the sap client {@code String} in an HTTP context.
     */
    String SAP_CLIENT_KEY = "sap-client";

    /**
     * The default property key to retrieve the locale {@code String} in an HTTP context.
     */
    String LOCALE_KEY = "sap-language";

    /**
     * The client to be used by this ErpDestination.
     *
     * @return The client of this ErpDestination.
     */
    @Nonnull
    default Option<SapClient> getSapClient()
    {
        return get(SAP_CLIENT_KEY, String.class).map(SapClient::of);
    }

    /**
     * The locale to be used by this ErpDestination.
     *
     * @return The locale of this ErpDestination
     */
    @Nonnull
    default Locale getLocale()
    {
        return get(LOCALE_KEY, String.class).map(Locale::forLanguageTag).getOrElse(LocaleAccessor::getCurrentLocale);
    }
}
