/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.RequestExecutionErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Thrown when something goes wrong during the execution of a request.
 */
@NoArgsConstructor
public class RequestExecutionException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = 1407979994822578835L;

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     */
    public RequestExecutionException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param cause
     *            The error cause.
     */
    public RequestExecutionException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     * @param cause
     *            The error cause.
     */
    public RequestExecutionException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new RequestExecutionErrorResponse(getMessage());
    }
}
