/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.VersionNotSupportedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Thrown when the version of a system or service is not supported.
 */
@NoArgsConstructor
public class VersionNotSupportedException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = -1877899746719623383L;

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     */
    public VersionNotSupportedException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param cause
     *            The error cause.
     */
    public VersionNotSupportedException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     * @param cause
     *            The error cause.
     */
    public VersionNotSupportedException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new VersionNotSupportedResponse(getMessage());
    }
}
