/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import lombok.Getter;

/**
 * Abstract base class for different types of request bodies.
 *
 * @deprecated This class has no usage, do not subclass from it.
 */
@Getter
@Deprecated
public abstract class RequestBody
{
    /**
     * Default constructor.
     * 
     * @param requestType
     *            The request type, e.g. "bapi".
     * @param requestId
     *            The request id.
     */
    public RequestBody( @Nonnull final String requestType, final long requestId )
    {
        this.requestType = requestType;
        this.requestId = requestId;
    }

    @Expose
    @SerializedName( "REQUEST_ID" )
    @JsonProperty( "REQUEST_ID" )
    private final long requestId;

    @Nonnull
    @Expose
    @SerializedName( "REQUEST_TYPE" )
    @JsonProperty( "REQUEST_TYPE" )
    private final String requestType;
}
