/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.s4hana.connectivity.RequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public abstract class Request<RequestT extends Request<RequestT, RequestResultT>, RequestResultT extends RequestResult<RequestT, RequestResultT>> {
    private static final AtomicLong requestIdCounter = new AtomicLong();
    private final long requestId;
    @Nullable
    private Duration longRunningRequestThreshold = null;
    @Nonnull
    private final List<Header> customHttpHeaders = new LinkedList<Header>();

    protected Request() {
        this.requestId = requestIdCounter.incrementAndGet();
    }

    @Nonnull
    public abstract String getConstructedByMethod();

    @Nullable
    public String getReadAccessData() {
        return null;
    }

    @Nonnull
    protected RequestT getThis() {
        return (RequestT)this;
    }

    @Nonnull
    public RequestT withHeader(@Nonnull String name, @Nullable String value) {
        return this.withHeader(new Header(name, value));
    }

    @Nonnull
    public RequestT withHeader(@Nonnull Header header) {
        this.customHttpHeaders.add(header);
        return this.getThis();
    }

    @Nonnull
    public RequestT withSameCustomHttpHeadersAs(@Nonnull Request<?, ?> otherRequest) {
        this.customHttpHeaders.addAll(otherRequest.getCustomHttpHeaders());
        return this.getThis();
    }

    @Nonnull
    public abstract RequestResultT execute(@Nonnull Destination var1) throws RequestSerializationException, RequestExecutionException, DestinationNotFoundException, DestinationAccessException;

    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    @Generated
    public Duration getLongRunningRequestThreshold() {
        return this.longRunningRequestThreshold;
    }

    @Generated
    public void setLongRunningRequestThreshold(@Nullable Duration longRunningRequestThreshold) {
        this.longRunningRequestThreshold = longRunningRequestThreshold;
    }

    @Nonnull
    @Generated
    public List<Header> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }
}

