/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.MissingConfigResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

import lombok.NoArgsConstructor;

/**
 * Thrown when configuration for accessing a certain system is missing.
 */
@NoArgsConstructor
public class MissingConfigException extends RequestExecutionException
{
    private static final long serialVersionUID = 472053808276154534L;

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     */
    public MissingConfigException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param cause
     *            The error cause.
     */
    public MissingConfigException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Constructor.
     * 
     * @param message
     *            The message.
     * @param cause
     *            The error cause.
     */
    public MissingConfigException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new MissingConfigResponse(getMessage());
    }
}
