/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpTypeGsonTypeAdapterFactory
implements TypeAdapterFactory {
    @Nullable
    public <T> TypeAdapter<T> create(@Nonnull Gson gson, @Nonnull TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (ErpType.class.isAssignableFrom(rawType)) {
            return new ErpTypeAdapter(rawType);
        }
        return null;
    }

    private static class ErpTypeAdapter<ErpTypeT extends ErpType<ErpTypeT>>
    extends TypeAdapter<ErpTypeT> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ErpTypeAdapter.class);
        @Nonnull
        private final Class<ErpTypeT> rawType;

        public ErpTypeAdapter(@Nonnull Class<ErpTypeT> rawType) {
            this.rawType = rawType;
        }

        public void write(@Nonnull JsonWriter out, @Nullable ErpTypeT value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value((String)value.getTypeConverter().toDomain(value).orNull());
            }
        }

        @Nullable
        public ErpTypeT read(@Nonnull JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            try {
                Class<?> cls = Class.forName(this.rawType.getName());
                String erpObject = reader.nextString();
                if (cls.isEnum()) {
                    ErpType enumConstant = (ErpType)cls.getEnumConstants()[0];
                    return (ErpTypeT)((ErpType)enumConstant.getTypeConverter().fromDomain((Object)erpObject).orNull());
                }
                Constructor<?> stringConstructor = cls.getConstructor(String.class);
                ErpType erpType = (ErpType)stringConstructor.newInstance("");
                return (ErpTypeT)((ErpType)erpType.getTypeConverter().fromDomain((Object)erpObject).orNull());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (log.isWarnEnabled()) {
                    log.warn("Failed to instantiate ERP type: " + this.rawType.getName() + ".", (Throwable)e);
                }
                return null;
            }
        }
    }
}

