/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.exception;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.servlet.response.AccessDeniedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class AccessDeniedException
extends RequestExecutionException {
    private static final long serialVersionUID = 8256471661877663966L;
    @Nullable
    protected transient Principal principal = null;
    @Nullable
    protected transient Set<Authorization> missingAuthorizations = null;

    @Nonnull
    public static AccessDeniedException raiseMissingAuthorizations(@Nullable Principal principal, @Nullable Iterable<? extends Authorization> missingAuthorizations) {
        return new AccessDeniedException(principal, missingAuthorizations != null ? Sets.newHashSet(missingAuthorizations) : null);
    }

    public AccessDeniedException(@Nullable String message) {
        super(message);
    }

    public AccessDeniedException(@Nullable Throwable cause) {
        super(cause);
    }

    public AccessDeniedException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public AccessDeniedException(@Nullable Principal principal, @Nullable Set<Authorization> missingAuthorizations) {
        super(AccessDeniedException.buildErrorMessage(principal, missingAuthorizations));
        this.principal = principal;
        this.missingAuthorizations = missingAuthorizations;
    }

    private static String buildErrorMessage(@Nullable Principal principal, @Nullable Iterable<? extends Authorization> missingAuthorizations) {
        if (principal != null) {
            return "Principal " + principal + " does not have the required authorizations" + (missingAuthorizations != null ? ": " + missingAuthorizations : "") + ".";
        }
        return "Missing authorizations" + (missingAuthorizations != null ? ": " + missingAuthorizations : "") + ".";
    }

    @Override
    @Nonnull
    public ResponseWithErrorCode getErrorResponse() {
        return new AccessDeniedResponse(null, null, "Access denied.");
    }

    @Generated
    public AccessDeniedException() {
    }

    @Nullable
    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Nullable
    @Generated
    public Set<Authorization> getMissingAuthorizations() {
        return this.missingAuthorizations;
    }
}

