/*
 * Copyright (c) 2023 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.connectivity;

import java.util.function.Function;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;

/**
 * Collection of convenience methods to work with {@link ErpHttpDestination}s.
 *
 * @deprecated without replacement. See the deprecation note on {@link ErpHttpDestination}.
 */
@Deprecated
public final class ErpHttpDestinationUtils
{
    private ErpHttpDestinationUtils()
    {
        // util classes should not be instantiated
    }

    /**
     * Convenience method to retrieve a destination by name via the {@link DestinationAccessor} and decorating it as a
     * {@link ErpHttpDestination}.
     *
     * @param destinationName
     *            The name of the destination to retrieve.
     * @return The destination with the given name as an {@code ErpHttpDestination}.
     * @throws com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException
     *             if the destination with the given name could not be found.
     * @throws IllegalArgumentException
     *             if the destination with the given name is no {@code HttpDestination}.
     * @deprecated without replacement. See the deprecation note on {@link ErpHttpDestination}.
     */
    @Deprecated
    @Nonnull
    public static ErpHttpDestination getErpHttpDestination( @Nonnull final String destinationName )
        throws DestinationAccessException,
            IllegalArgumentException
    {
        return DestinationAccessor.getDestination(destinationName).asHttp().decorate(asErp());
    }

    /**
     * Convenience method to decorate a generic {@link com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination
     * HttpDestination} into an ERP specific {@link ErpHttpDestination}.
     *
     * @return A function that can be used in the
     *         {@link com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination#decorate(Function)} to create a
     *         {@code ErpHttpDestination}.
     * @deprecated without replacement. See the deprecation note on {@link ErpHttpDestination}.
     */
    @Nonnull
    @Deprecated
    public static Function<HttpDestinationProperties, ErpHttpDestination> asErp()
    {
        return DefaultErpHttpDestination::new;
    }
}
