/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleAccessor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpHttpDestination;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import io.vavr.control.Option;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultErpHttpDestination
implements ErpHttpDestination {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultErpHttpDestination.class);
    public static final String SAP_CLIENT_HEADER_NAME = "sap-client";
    public static final String LOCALE_HEADER_NAME = "sap-language";
    private final HttpDestinationProperties baseDestination;

    public DefaultErpHttpDestination(@Nonnull HttpDestinationProperties baseDestination) {
        this.baseDestination = baseDestination;
    }

    @Nonnull
    public Option<Object> get(@Nonnull String key) {
        return this.baseDestination.get(key);
    }

    @Nonnull
    public Iterable<String> getPropertyNames() {
        return this.baseDestination.getPropertyNames();
    }

    @Nonnull
    public URI getUri() {
        return this.baseDestination.getUri();
    }

    @Nonnull
    public Option<String> getTlsVersion() {
        return this.baseDestination.getTlsVersion();
    }

    @Nonnull
    public Option<ProxyConfiguration> getProxyConfiguration() {
        return this.baseDestination.getProxyConfiguration();
    }

    @Nonnull
    public Option<KeyStore> getKeyStore() {
        return this.baseDestination.getKeyStore();
    }

    @Nonnull
    public Option<String> getKeyStorePassword() {
        return this.baseDestination.getKeyStorePassword();
    }

    public boolean isTrustingAllCertificates() {
        return this.baseDestination.isTrustingAllCertificates();
    }

    @Nonnull
    public Option<BasicCredentials> getBasicCredentials() {
        return this.baseDestination.getBasicCredentials();
    }

    @Nonnull
    public Option<ProxyType> getProxyType() {
        return this.baseDestination.getProxyType();
    }

    @Nonnull
    public Option<String> getName() {
        return this.baseDestination.get("Name", String.class::cast);
    }

    @Nonnull
    public Option<KeyStore> getTrustStore() {
        return this.baseDestination.getTrustStore();
    }

    @Nonnull
    public Option<String> getTrustStorePassword() {
        return this.baseDestination.getTrustStorePassword();
    }

    @Nonnull
    public AuthenticationType getAuthenticationType() {
        return this.baseDestination.getAuthenticationType();
    }

    @Nonnull
    public Collection<Header> getHeaders(@Nonnull URI requestUri) {
        Collection headers = this.baseDestination.getHeaders(requestUri);
        boolean languageHeaderDefined = headers.stream().anyMatch(h -> DestinationProperty.SAP_LANGUAGE.getKeyName().equalsIgnoreCase(h.getName()));
        if (!languageHeaderDefined) {
            headers.add(new Header(DestinationProperty.SAP_LANGUAGE.getKeyName(), LocaleAccessor.getCurrentLocale().getLanguage()));
        }
        return headers;
    }

    @Nonnull
    public static Builder builder(@Nonnull URI uri) {
        return new Builder(uri);
    }

    @Nonnull
    public static Builder builder(@Nonnull String uri) {
        return DefaultErpHttpDestination.builder(URI.create(uri));
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultErpHttpDestination)) {
            return false;
        }
        DefaultErpHttpDestination other = (DefaultErpHttpDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpDestinationProperties this$baseDestination = this.baseDestination;
        HttpDestinationProperties other$baseDestination = other.baseDestination;
        return !(this$baseDestination == null ? other$baseDestination != null : !this$baseDestination.equals(other$baseDestination));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DefaultErpHttpDestination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpDestinationProperties $baseDestination = this.baseDestination;
        result = result * 59 + ($baseDestination == null ? 43 : $baseDestination.hashCode());
        return result;
    }

    public static class Builder {
        private final DefaultHttpDestination.Builder builder;

        Builder(@Nonnull URI uri) {
            this.builder = DefaultHttpDestination.builder((URI)uri);
        }

        @Nonnull
        public Builder sapClient(@Nonnull SapClient sapClient) {
            this.builder.property(DestinationProperty.SAP_CLIENT.getKeyName(), (Object)sapClient.getValue());
            return this;
        }

        @Nonnull
        public Builder locale(@Nonnull Locale locale) {
            this.builder.property(DestinationProperty.SAP_LANGUAGE.getKeyName(), (Object)locale.getLanguage());
            return this;
        }

        @Nonnull
        public Builder tlsVersion(@Nonnull String value) {
            this.builder.tlsVersion(value);
            return this;
        }

        @Nonnull
        public Builder property(@Nonnull String key, @Nonnull Object value) {
            this.builder.property(key, value);
            return this;
        }

        @Nonnull
        public Builder keyStorePassword(@Nonnull String value) {
            this.builder.keyStorePassword(value);
            return this;
        }

        @Nonnull
        public Builder keyStore(@Nonnull KeyStore keyStore) {
            this.builder.keyStore(keyStore);
            return this;
        }

        @Nonnull
        public Builder trustAllCertificates() {
            this.builder.trustAllCertificates();
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.builder.name(name);
            return this;
        }

        @Nonnull
        public Builder proxy(@Nonnull URI proxyUri) {
            this.builder.proxy(proxyUri);
            return this;
        }

        @Nonnull
        public Builder proxy(@Nonnull String proxyHost, int proxyPort) {
            this.builder.proxy(proxyHost, proxyPort);
            return this;
        }

        @Nonnull
        public Builder proxyType(@Nonnull ProxyType proxyType) {
            return this.property("proxyType", proxyType);
        }

        @Nonnull
        public Builder authenticationType(@Nonnull AuthenticationType authenticationType) {
            this.builder.authenticationType(authenticationType);
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull String user) {
            this.builder.user(user);
            return this;
        }

        @Nonnull
        public Builder password(@Nonnull String password) {
            this.builder.password(password);
            return this;
        }

        @Nonnull
        public Builder basicCredentials(@Nonnull BasicCredentials basicCredentials) {
            if (basicCredentials != null) {
                this.builder.user(basicCredentials.getUsername());
                this.builder.password(basicCredentials.getPassword());
            }
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull Header header) {
            this.builder.header(header);
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull String headerName, @Nonnull String headerValue) {
            this.builder.header(headerName, headerValue);
            return this;
        }

        @Nonnull
        public DefaultErpHttpDestination build() {
            return new DefaultErpHttpDestination((HttpDestinationProperties)this.builder.build());
        }
    }
}

