/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpBooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ErpTypeSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErpTypeSerializer.class);
    private final Map<Class<?>, ErpTypeConverter<?>> typeConverters = Maps.newIdentityHashMap();

    public ErpTypeSerializer() {
        this.withTypeConverters(new ErpTypeConverter[]{BooleanConverter.INSTANCE, CharacterConverter.INSTANCE, ByteConverter.INSTANCE, ShortConverter.INSTANCE, IntegerConverter.INSTANCE, LongConverter.INSTANCE, FloatConverter.INSTANCE, DoubleConverter.INSTANCE, BigIntegerConverter.INSTANCE, BigDecimalConverter.INSTANCE, YearConverter.INSTANCE, LocalDateConverter.INSTANCE, LocalTimeConverter.INSTANCE, LocaleConverter.INSTANCE, ErpDecimalConverter.INSTANCE, ErpBooleanConverter.INSTANCE});
    }

    @Nonnull
    public ErpTypeSerializer withTypeConverters(@Nonnull Iterable<ErpTypeConverter<?>> typeConverters) {
        for (ErpTypeConverter<?> typeConverter : typeConverters) {
            this.typeConverters.put(typeConverter.getType(), typeConverter);
        }
        return this;
    }

    @Nonnull
    public ErpTypeSerializer withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return this.withTypeConverters(Arrays.asList(typeConverters));
    }

    @Nonnull
    public Collection<ErpTypeConverter<?>> getTypeConverters() {
        return this.typeConverters.values();
    }

    @Nonnull
    public Map<Class<?>, ErpTypeConverter<?>> getTypeConvertersByType() {
        return this.typeConverters;
    }

    @Nullable
    private <T> ErpTypeConverter<T> getTypeConverter(Class<T> type) {
        return this.typeConverters.get(type);
    }

    @Nonnull
    public <T> ConvertedObject<String> toErp(@Nullable T object) {
        ConvertedObject erpObject;
        if (object == null) {
            return ConvertedObject.ofNull();
        }
        if (object instanceof ErpType) {
            ErpTypeConverter converter = ((ErpType)object).getTypeConverter();
            erpObject = converter.toDomain(object);
        } else {
            ErpTypeConverter<?> converter = this.getTypeConverter(object.getClass());
            erpObject = converter != null ? converter.toDomain(object) : ConvertedObject.of((Object)object.toString());
        }
        return erpObject;
    }

    @Nonnull
    public <T> ConvertedObject<T> fromErp(@Nullable String erpObject, @Nonnull Class<T> resultType) {
        if (erpObject == null) {
            return ConvertedObject.ofNull();
        }
        ErpTypeConverter<T> converter = this.getTypeConverter(resultType);
        if (converter != null) {
            return converter.fromDomain((Object)erpObject);
        }
        try {
            Constructor<T> stringConstructor = resultType.getConstructor(String.class);
            return ConvertedObject.of(stringConstructor.newInstance(erpObject));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new ShouldNotHappenException(String.format("Failed to instantiate object from %s: No constructor available with %s parameter.", resultType.getSimpleName(), String.class.getSimpleName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to convert ERP object to " + resultType.getName() + ": " + erpObject + ".");
            }
            return ConvertedObject.ofNotConvertible();
        }
    }
}

