/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.s4hana.connectivity.Request;
import com.sap.cloud.sdk.s4hana.connectivity.RequestExecutionMeasurements;
import com.sap.cloud.sdk.s4hana.connectivity.RequestMethod;
import com.sap.cloud.sdk.s4hana.connectivity.RequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.RequestSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequest;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.ServiceUriBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AccessDeniedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.CloudConnectorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.LogonErrorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ErpHttpRequestExecutor<RequestT extends Request<RequestT, RequestResultT>, RequestResultT extends RequestResult<RequestT, RequestResultT>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErpHttpRequestExecutor.class);
    private static final int MAX_UNCOMPRESSED_PAYLOAD_LENGTH = 1400;
    private final RequestExecutionMeasurements measurements = new RequestExecutionMeasurements();

    @Nonnull
    private ByteArrayEntity getBodyAsCompressedEntity(@Nonnull String body) throws RequestSerializationException {
        ByteArrayEntity entity;
        byte[] content;
        try {
            content = body.getBytes(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestSerializationException("Failed to to convert payload from String to UTF8 byte[].", e);
        }
        if (content.length > 1400) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                gzipOutputStream.write(content);
            }
            catch (IOException e) {
                throw new RequestSerializationException("Failed to write to GZIP-compressed stream.", e);
            }
            entity = new ByteArrayEntity(outputStream.toByteArray());
            entity.setContentEncoding("gzip");
            if (log.isInfoEnabled()) {
                log.info("Compressed length of ERP request body: " + entity.getContentLength() + " bytes, was " + content.length + " bytes.");
            }
        } else {
            entity = new ByteArrayEntity(content);
            entity.setContentEncoding(StandardCharsets.UTF_8.toString());
            if (log.isInfoEnabled()) {
                log.info("Length of ERP request body: " + entity.getContentLength() + " bytes.");
            }
        }
        return entity;
    }

    private void handleHttpStatus(@Nonnull HttpDestination destination, int statusCode, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws RequestExecutionException {
        if (statusCode == 200) {
            if (log.isTraceEnabled()) {
                log.trace("Request execution finished successfully. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".");
            }
        } else {
            this.handleHttpError(destination, statusCode, responseBody, responseHeaders);
        }
    }

    private void handleHttpError(@Nonnull HttpDestination destination, int statusCode, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws RequestExecutionException {
        switch (statusCode) {
            case 401: {
                this.handleUnauthorized(responseBody, responseHeaders);
                return;
            }
            case 403: {
                this.handleForbidden(responseBody, responseHeaders);
                return;
            }
            case 500: {
                this.handleInternalServerError(responseBody, responseHeaders);
                return;
            }
            case 503: {
                this.handleServiceUnavailableError(destination, responseBody, responseHeaders);
                return;
            }
            case 502: {
                this.handleBadGateway(responseBody, responseHeaders);
                return;
            }
        }
        String message = "Request execution failed with status code " + statusCode + ". Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new RequestExecutionException(message);
    }

    private void handleUnauthorized(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws LogonErrorException {
        String message = "401 Unauthorized. The connection attempt was refused. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new LogonErrorException(message);
    }

    @Nullable
    private String getMissingAuthorization(@Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) {
        for (com.sap.cloud.sdk.cloudplatform.connectivity.Header header : responseHeaders) {
            if (!header.getName().equals("failed-authorization-object")) continue;
            return header.getValue();
        }
        return null;
    }

    private void handleForbidden(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws AccessDeniedException {
        String prefix = "403 Forbidden. ";
        if (responseBody != null && responseBody.startsWith("CX_FINS_MAP_NO_AUTH_QUERY_EXEC")) {
            String missingAuthorization = this.getMissingAuthorization(responseHeaders);
            throw AccessDeniedException.raiseMissingAuthorizations(null, missingAuthorization);
        }
        String message = "403 Forbidden. Failed to establish a trusted connection to the ERP. This may be caused by a misconfiguration of the SAP Cloud Connector or a misconfiguration of the trust certificate. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new AccessDeniedException(message);
    }

    private void handleInternalServerError(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws RequestExecutionException {
        String prefix = "500 Internal Server Error. ";
        if (responseBody != null && responseBody.contains("ICF") && responseBody.contains("HCPMAPBM")) {
            String message = "500 Internal Server Error. Failed to invoke ICF service. Does the user have authorization HCPMAPBM? Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new AccessDeniedException(message);
        }
        String message = "500 Internal Server Error. Request execution failed with unexpected error. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new RequestExecutionException(message);
    }

    private void handleServiceUnavailableError(@Nonnull HttpDestination destination, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws RequestExecutionException {
        if (responseBody != null && responseBody.contains("No tunnels subscribed for tunnelId")) {
            String message = "503 Service Unavailable. Failed to connect to ERP system. Please check the configuration of destination '" + (String)destination.get(DestinationProperty.NAME).getOrElse((Object)"") + "'. In an on-premise setup, ensure that the cloud connector is connected.";
            throw new CloudConnectorException(503, message);
        }
        this.handleInternalServerError(responseBody, responseHeaders);
    }

    private void handleBadGateway(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws RequestExecutionException {
        if (responseBody != null && responseBody.contains("Unable to open connection to backend system")) {
            String message = "502 Bad Gateway. Cloud connector failed to open connection to backend system. Is the internal host configured correc   tly? Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new CloudConnectorException(502, message);
        }
        this.handleInternalServerError(responseBody, responseHeaders);
    }

    @Nonnull
    private String getNonSensitiveHeadersAsString(@Nonnull Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers) {
        StringBuilder sb = new StringBuilder();
        Iterator<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headerIt = headers.iterator();
        while (headerIt.hasNext()) {
            com.sap.cloud.sdk.cloudplatform.connectivity.Header header = headerIt.next();
            String name = header.getName();
            String value = header.getValue();
            if ("set-cookie".equalsIgnoreCase(name) || "authorization".equalsIgnoreCase(name)) {
                value = "(hidden)";
            }
            sb.append(name).append(": ").append(value).append(headerIt.hasNext() ? ", " : "");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RequestResultT execute(@Nonnull HttpDestination destination, @Nonnull RequestT request, @Nonnull RequestSerializer<RequestT, RequestResultT> requestSerializer) throws RequestSerializationException, RequestExecutionException, DestinationNotFoundException, DestinationAccessException {
        this.measurements.resetMeasurements();
        this.measurements.setBeginTotal(System.nanoTime());
        try {
            SerializedRequest<RequestT> serializedRequest = this.serializeRequest(request, requestSerializer);
            String responseBody = this.execute(destination, serializedRequest);
            RequestResultT RequestResultT = this.deserializeRequest(request, requestSerializer, responseBody);
            return RequestResultT;
        }
        finally {
            this.measurements.setEndTotal(System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private SerializedRequest<RequestT> serializeRequest(@Nonnull RequestT request, @Nonnull RequestSerializer<RequestT, RequestResultT> requestSerializer) throws RequestSerializationException, DestinationNotFoundException, DestinationAccessException {
        long beginBuildReq = System.nanoTime();
        try {
            SerializedRequest<RequestT> serializedRequest = requestSerializer.serialize(request);
            return serializedRequest;
        }
        finally {
            long endBuildReq = System.nanoTime();
            this.measurements.addBuildRequestDuration(Duration.ofNanos(endBuildReq - beginBuildReq));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private RequestResultT deserializeRequest(@Nonnull RequestT request, @Nonnull RequestSerializer<RequestT, RequestResultT> requestSerializer, @Nonnull String responseBody) throws RequestSerializationException, DestinationNotFoundException, DestinationAccessException {
        long beginParseResp = System.nanoTime();
        try {
            SerializedRequestResult<RequestT> serializedRequestResult = new SerializedRequestResult<RequestT>(request, responseBody);
            RequestResultT RequestResultT = requestSerializer.deserialize(serializedRequestResult);
            return RequestResultT;
        }
        finally {
            long endParseResp = System.nanoTime();
            this.measurements.addParseResponseDuration(Duration.ofNanos(endParseResp - beginParseResp));
        }
    }

    @Nonnull
    private RequestMethod getRequestMethod(@Nonnull SerializedRequest<RequestT> serializedRequest) {
        return serializedRequest.getRequestMethod();
    }

    @Nonnull
    protected URI getRequestUri(@Nonnull HttpDestination destination, @Nonnull SerializedRequest<RequestT> serializedRequest) {
        return new ServiceUriBuilder().build(destination.getUri(), serializedRequest.getRequestPath());
    }

    private HttpUriRequest newRequest(RequestMethod requestMethod, URI requestUri) {
        switch (requestMethod) {
            case GET: {
                return new HttpGet(requestUri);
            }
            case HEAD: {
                return new HttpHead(requestUri);
            }
            case POST: {
                return new HttpPost(requestUri);
            }
            case PUT: {
                return new HttpPut(requestUri);
            }
            case PATCH: {
                return new HttpPatch(requestUri);
            }
            case DELETE: {
                return new HttpDelete(requestUri);
            }
            case OPTIONS: {
                return new HttpOptions(requestUri);
            }
        }
        throw new ShouldNotHappenException("Unsupported request method: " + String.valueOf((Object)requestMethod) + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpUriRequest newRequest(@Nonnull RequestMethod requestMethod, @Nonnull URI requestUri, @Nonnull RequestBodyWithHeader bodyWithHeader) throws RequestSerializationException {
        long beginBuildRequest = System.nanoTime();
        try {
            HttpUriRequest request = this.newRequest(requestMethod, requestUri);
            if (request instanceof HttpEntityEnclosingRequest) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)this.getBodyAsCompressedEntity(bodyWithHeader.body));
            }
            request.setHeader("User-Agent", "sap-cloud-sdk");
            request.setHeader("Accept-Encoding", "gzip");
            for (com.sap.cloud.sdk.cloudplatform.connectivity.Header header : bodyWithHeader.headers) {
                request.setHeader(header.getName(), header.getValue());
            }
            if (log.isTraceEnabled()) {
                Thread currentThread = Thread.currentThread();
                log.trace("Successfully prepared HTTP request for request execution (thread: " + String.valueOf(currentThread) + ", threat id: " + currentThread.getId() + ") URI: " + String.valueOf(requestUri) + " Body: " + bodyWithHeader.body + " Headers: " + this.getNonSensitiveHeadersAsString(bodyWithHeader.headers) + ".");
            }
            HttpUriRequest httpUriRequest = request;
            return httpUriRequest;
        }
        finally {
            this.measurements.addBuildRequestDuration(Duration.ofNanos(System.nanoTime() - beginBuildRequest));
        }
    }

    protected void logReadAccessAttempt(Request<?, ?> request, HttpDestination destination) {
        String readAccessData = request.getReadAccessData();
        if (readAccessData != null) {
            log.info("Read access attempt from class: {} for destination: {}, sap-client: {}, constructed by {}, with data: {}.", new Object[]{request.getClass().getSimpleName(), destination.get(DestinationProperty.NAME).get(), destination.get(DestinationProperty.SAP_CLIENT).get(), request.getConstructedByMethod(), readAccessData});
        }
    }

    private String getRequestExecutionFailedMessage(Request<?, ?> request) {
        return request.getClass().getSimpleName() + " " + request.getConstructedByMethod() + " failed [" + this.measurements.getMeasurementsString() + "]";
    }

    @Nonnull
    public String execute(@Nonnull HttpDestination destination, @Nonnull SerializedRequest<RequestT> serializedRequest) throws RequestSerializationException, RequestExecutionException, DestinationNotFoundException, DestinationAccessException {
        String responseBody;
        HttpResponse response;
        RequestT request = serializedRequest.getRequest();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        RequestMethod requestMethod = this.getRequestMethod(serializedRequest);
        URI requestUri = this.getRequestUri(destination, serializedRequest);
        RequestBodyWithHeader bodyWithHeader = this.getRequestBodyWithHeader(destination, serializedRequest);
        HttpUriRequest uriRequest = this.newRequest(requestMethod, requestUri, bodyWithHeader);
        ArrayList<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders = new ArrayList<com.sap.cloud.sdk.cloudplatform.connectivity.Header>();
        long beginExecute = System.nanoTime();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Executing " + request.getClass().getSimpleName() + " constructed by: " + ((Request)request).getConstructedByMethod() + ".");
            }
            this.logReadAccessAttempt((Request<?, ?>)request, destination);
            response = httpClient.execute(uriRequest);
            for (Header header : response.getAllHeaders()) {
                responseHeaders.add(new com.sap.cloud.sdk.cloudplatform.connectivity.Header(header.getName(), header.getValue()));
            }
            responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
        }
        catch (RequestSerializationException e) {
            if (log.isDebugEnabled()) {
                log.debug(this.getRequestExecutionFailedMessage((Request<?, ?>)request), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String message = this.getRequestExecutionFailedMessage((Request<?, ?>)request);
            throw new RequestExecutionException(message, e);
        }
        finally {
            this.measurements.addExecuteRequestDuration(Duration.ofNanos(System.nanoTime() - beginExecute));
        }
        if (responseBody == null) {
            throw new RequestExecutionException("Failed to execute request: no body returned in response.");
        }
        this.handleHttpStatus(destination, response.getStatusLine().getStatusCode(), responseBody, responseHeaders);
        return responseBody;
    }

    @Nonnull
    protected RequestBodyWithHeader getRequestBodyWithHeader(HttpDestination destination, @Nonnull SerializedRequest<RequestT> request) {
        return new RequestBodyWithHeader(request.getRequestHeaders(), request.getRequestBody());
    }

    @Generated
    public RequestExecutionMeasurements getMeasurements() {
        return this.measurements;
    }

    static final class RequestBodyWithHeader {
        private final Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers;
        private final String body;

        @Generated
        public RequestBodyWithHeader(Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers, String body) {
            this.headers = headers;
            this.body = body;
        }

        @Generated
        public Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestBodyWithHeader)) {
                return false;
            }
            RequestBodyWithHeader other = (RequestBodyWithHeader)o;
            Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> this$headers = this.getHeaders();
            Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<com.sap.cloud.sdk.cloudplatform.connectivity.Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ErpHttpRequestExecutor.RequestBodyWithHeader(headers=" + String.valueOf(this.getHeaders()) + ", body=" + this.getBody() + ")";
        }
    }
}

