/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class MDCHelper {
    public static final String CORRELATION_ID = "correlation_id";
    public static final String CORRELATION_HEADER = "X-CorrelationID";
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCHelper.class);

    private MDCHelper() {
    }

    public static String getOrCreateCorrelationId() {
        String correlationId = MDC.get((String)CORRELATION_ID);
        if (correlationId == null || correlationId.isEmpty()) {
            correlationId = String.valueOf(UUID.randomUUID());
            LOGGER.info("Correlation id (key={}) was not found in the MDC, generating a new one: {}", (Object)CORRELATION_ID, (Object)correlationId);
        } else {
            LOGGER.debug("Correlation id (key={}) from MDC: {}", (Object)CORRELATION_ID, (Object)correlationId);
        }
        return correlationId;
    }
}

