/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.Service;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface OAuth2ServiceConfiguration {
    public String getClientId();

    public String getClientSecret();

    default public ClientIdentity getClientIdentity() {
        ClientIdentity identity = new ClientCertificate(this.getProperty("certificate"), this.getProperty("key"), this.getClientId());
        if (!identity.isValid()) {
            identity = new ClientCredentials(this.getClientId(), this.getClientSecret());
        }
        return identity;
    }

    @Nullable
    default public CredentialType getCredentialType() {
        if (this.getClientIdentity() != null && this.getClientIdentity().isCertificateBased()) {
            return CredentialType.X509;
        }
        return CredentialType.from(this.getProperty("credential-type"));
    }

    public URI getUrl();

    @Nullable
    default public URI getCertUrl() {
        return null;
    }

    default public List<String> getDomains() {
        return Collections.emptyList();
    }

    @Nullable
    public String getProperty(String var1);

    public Map<String, String> getProperties();

    public boolean hasProperty(String var1);

    public Service getService();

    public boolean isLegacyMode();
}

