/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import javax.annotation.Nullable;

public enum CredentialType {
    X509("x509"),
    INSTANCE_SECRET("instance-secret"),
    BINDING_SECRET("binding-secret"),
    X509_GENERATED("X509_GENERATED"),
    X509_PROVIDED("X509_PROVIDED"),
    X509_ATTESTED("X509_ATTESTED");

    private final String typeName;

    private CredentialType(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName;
    }

    @Nullable
    public static CredentialType from(String claimValue) {
        for (CredentialType credentialType : CredentialType.values()) {
            if (!credentialType.typeName.equalsIgnoreCase(claimValue)) continue;
            return credentialType;
        }
        return null;
    }
}

