/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IasXsuaaExchangeBroker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IasXsuaaExchangeBroker.class);
    private XsuaaTokenFlows xsuaaTokenFlows;

    private IasXsuaaExchangeBroker() {
    }

    static IasXsuaaExchangeBroker build(OAuth2ServiceConfiguration configuration, OAuth2TokenService tokenService) {
        IasXsuaaExchangeBroker broker = new IasXsuaaExchangeBroker();
        Assertions.assertNotNull((Object)configuration, (String)"Service configuration must not be null");
        Assertions.assertNotNull((Object)tokenService, (String)"Oauth2 Token Service must not be null");
        LOGGER.debug("Initializing XsuaaTokenFlow ({} based authentication)", (Object)(configuration.getCredentialType() == CredentialType.X509 ? "certificate" : "client secret"));
        broker.xsuaaTokenFlows = new XsuaaTokenFlows(tokenService, (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(configuration), configuration.getClientIdentity());
        return broker;
    }

    @Nullable
    public String resolve(Token token) throws TokenFlowException, HttpClientException {
        OAuth2TokenResponse tokenResponse = this.xsuaaTokenFlows.userTokenFlow().token(token).execute();
        LOGGER.debug("Response token from Ias to Xsuaa token exchange {}", (Object)tokenResponse.getAccessToken());
        return tokenResponse.getAccessToken();
    }
}

