/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.x509.Certificate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtX5tValidator
implements Validator<Token> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtX5tValidator.class);
    private final OAuth2ServiceConfiguration config;

    public JwtX5tValidator(OAuth2ServiceConfiguration config) {
        this.config = config;
    }

    @Override
    public ValidationResult validate(Token token) {
        String tokenX5t = JwtX5tValidator.extractCnfThumbprintFromToken(token);
        LOGGER.debug("Token 'cnf' thumbprint: {}", (Object)tokenX5t);
        if (tokenX5t != null) {
            Certificate clientCertificate = SecurityContext.getClientCertificate();
            if (clientCertificate == null) {
                LOGGER.error("Client certificate missing from SecurityContext");
                return ValidationResults.createInvalid("Certificate validation failed");
            }
            String clientCertificateX5t = clientCertificate.getThumbprint();
            if (clientCertificateX5t.equals(tokenX5t)) {
                if (token.getAudiences().size() == 1 && token.getAudiences().contains(this.config.getClientId())) {
                    return ValidationResults.createValid();
                }
                LOGGER.error("Audience validation failed -> \"aud\": {} != \"clientid\": \"{}\"", (Object)token.getAudiences(), (Object)this.config.getClientId());
            } else {
                LOGGER.error("Thumbprint validation failed -> x5t from token: \"{}\" != thumbprint from client certificate: \"{}\"", (Object)tokenX5t, (Object)clientCertificateX5t);
            }
        }
        return ValidationResults.createInvalid("Certificate validation failed");
    }

    @Nullable
    private static String extractCnfThumbprintFromToken(Token token) {
        JsonObject cnf = token.getClaimAsJsonObject("cnf");
        return cnf == null ? null : cnf.getAsString("x5t#S256");
    }
}

