/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.IasXsuaaExchangeBroker;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticatorResult;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.X509Certificate;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaTokenAuthenticator
extends AbstractTokenAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaTokenAuthenticator.class);
    private static final String IAS_XSUAA_ENABLED = "IAS_XSUAA_XCHANGE_ENABLED";
    private IasXsuaaExchangeBroker exchangeBroker;

    public XsuaaTokenAuthenticator() {
        this.serviceConfiguration = Environments.getCurrent().getXsuaaConfiguration();
        this.httpClient = HttpClientFactory.create(this.serviceConfiguration != null ? this.serviceConfiguration.getClientIdentity() : null);
        this.buildDependencies();
    }

    XsuaaTokenAuthenticator(IasXsuaaExchangeBroker exchangeBroker) {
        this.exchangeBroker = exchangeBroker;
    }

    @Override
    public AbstractTokenAuthenticator withServiceConfiguration(OAuth2ServiceConfiguration serviceConfiguration) {
        super.withServiceConfiguration(serviceConfiguration);
        this.buildDependencies();
        return this;
    }

    @Override
    public AbstractTokenAuthenticator withHttpClient(CloseableHttpClient httpClient) {
        super.withHttpClient(httpClient);
        this.buildDependencies();
        return this;
    }

    private void buildDependencies() {
        if (this.serviceConfiguration != null && this.httpClient != null && this.isIasXsuaaXchangeEnabled()) {
            this.exchangeBroker = IasXsuaaExchangeBroker.build(this.serviceConfiguration, (OAuth2TokenService)new DefaultOAuth2TokenService(this.httpClient));
        }
    }

    @Override
    public Token extractFromHeader(String authorizationHeader) {
        return new XsuaaToken(authorizationHeader).withScopeConverter(this.getScopeConverter());
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        OAuth2ServiceConfiguration config;
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = config = this.serviceConfiguration != null ? this.serviceConfiguration : Environments.getCurrent().getXsuaaConfiguration();
        if (config == null) {
            throw new IllegalStateException("There must be a service configuration.");
        }
        return config;
    }

    @Override
    @Nullable
    protected OAuth2ServiceConfiguration getOtherServiceConfiguration() {
        return Environments.getCurrent().getXsuaaConfigurationForTokenExchange();
    }

    @Override
    protected TokenAuthenticationResult authenticated(Token token) {
        Set<String> translatedScopes = this.getScopeConverter().convert(((XsuaaToken)token).getScopes());
        return TokenAuthenticatorResult.createAuthenticated(translatedScopes, token);
    }

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String authorizationHeader = httpRequest.getHeader("Authorization");
            if (this.headerIsAvailable(authorizationHeader)) {
                try {
                    SecurityContext.setClientCertificate((Certificate)X509Certificate.newCertificate(this.getClientCertificate(httpRequest)));
                    Token token = Token.create((String)authorizationHeader);
                    if (token.getService() == Service.IAS) {
                        if (this.exchangeBroker == null) {
                            return this.unauthenticated("IAS token validation is not supported: " + (this.isIasXsuaaXchangeEnabled() ? "setup is malicious." : "no token exchange enabled."));
                        }
                        if (this.isIasXsuaaXchangeEnabled()) {
                            LOGGER.debug("Received {} token", (Object)token.getService());
                            token = new XsuaaToken(Objects.requireNonNull(this.exchangeBroker.resolve(token), "IasXsuaaExchangeBroker is not provided")).withScopeConverter(this.getScopeConverter());
                        }
                    }
                    return this.tokenValidationResult(token);
                }
                catch (Exception e) {
                    return TokenAuthenticatorResult.createUnauthenticated("Unexpected error occurred: " + e.getMessage());
                }
            }
            return TokenAuthenticatorResult.createUnauthenticated("Authorization header is missing.");
        }
        return TokenAuthenticatorResult.createUnauthenticated("Could not process request " + request);
    }

    private ScopeConverter getScopeConverter() {
        return new XsuaaScopeConverter(this.getServiceConfiguration().getProperty("xsappname"));
    }

    private boolean isIasXsuaaXchangeEnabled() {
        String isEnabled = System.getenv(IAS_XSUAA_ENABLED);
        LOGGER.debug("System environment variable {} is set to {}", (Object)IAS_XSUAA_ENABLED, (Object)isEnabled);
        return isEnabled != null && !isEnabled.equalsIgnoreCase("false");
    }
}

