/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.AbstractToken;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SapIdToken
extends AbstractToken {
    static final String IAS_ISSUER = "ias_iss";

    public SapIdToken(@Nonnull DecodedJwt decodedJwt) {
        super(decodedJwt);
    }

    public SapIdToken(@Nonnull String idToken) {
        super(idToken);
    }

    public Principal getPrincipal() {
        return this.createPrincipalByName(this.getClaimAsString("user_uuid"));
    }

    public Service getService() {
        return Service.IAS;
    }

    public String getIssuer() {
        if (this.hasClaim(IAS_ISSUER)) {
            return this.getClaimAsString(IAS_ISSUER);
        }
        return super.getIssuer();
    }

    String getCustomIssuer() {
        if (this.hasClaim(IAS_ISSUER)) {
            return this.getClaimAsString("iss");
        }
        return null;
    }

    @Nullable
    public String getCnfX509Thumbprint() {
        return this.getAttributeFromClaimAsString("cnf", "x5t#S256");
    }
}

