/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.json.JsonParsingException;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.TestIssuerValidator;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JwtIssuerValidator
implements Validator<Token> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JwtIssuerValidator.class);
    static TestIssuerValidator localhostIssuerValidator;
    protected static final String HTTPS_SCHEME = "https://";
    private final List<String> domains;

    private static void tryLoadingLocalhostIssuerValidator() {
        ServiceLoader<TestIssuerValidator> validators;
        try {
            validators = ServiceLoader.load(TestIssuerValidator.class);
        }
        catch (Exception | ServiceConfigurationError e) {
            LOGGER.warn("Unexpected failure while loading TestIssuerValidator service providers: {}", (Object)e.getMessage());
            return;
        }
        Iterator<TestIssuerValidator> iterator = validators.iterator();
        if (iterator.hasNext()) {
            TestIssuerValidator v;
            localhostIssuerValidator = v = iterator.next();
        }
        LOGGER.debug("loaded TestIssuerValidator service providers: {}. Using first one: {}.", validators, (Object)localhostIssuerValidator);
    }

    JwtIssuerValidator(List<String> domains) {
        Assertions.assertNotEmpty(domains, (String)"JwtIssuerValidator requires a domain(s).");
        this.domains = domains;
    }

    @Override
    public ValidationResult validate(Token token) {
        String issuer;
        try {
            issuer = token.getIssuer();
        }
        catch (JsonParsingException e) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because token issuer claim was not a String value.");
        }
        if (issuer == null || issuer.trim().isEmpty()) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because token does not contain an issuer claim.");
        }
        String issuerUrl = issuer.startsWith(HTTPS_SCHEME) || issuer.startsWith("http://localhost") ? issuer : HTTPS_SCHEME + issuer;
        try {
            new URL(issuerUrl);
        }
        catch (MalformedURLException e) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because token issuer is not a valid URL suitable for https.");
        }
        String issuerDomain = issuerUrl.substring(issuerUrl.indexOf("://") + 3);
        for (String d : this.domains) {
            String validSubdomainPattern = String.format("^[a-zA-Z0-9-]{1,63}\\.%s$", Pattern.quote(d));
            if (Objects.equals(d, issuerDomain) || issuerDomain.matches(validSubdomainPattern)) {
                return ValidationResults.createValid();
            }
            if (!"localhost".equals(d) || localhostIssuerValidator == null || !localhostIssuerValidator.isValidIssuer(issuer)) continue;
            LOGGER.debug("Accepting {} as valid issuer on trusted domain 'localhost' for backward-compatibility with java-security-test.", (Object)issuer);
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Issuer {} was not a trusted domain or a subdomain of the trusted domains {}.", issuer, this.domains);
    }

    static {
        JwtIssuerValidator.tryLoadingLocalhostIssuerValidator();
    }
}

