/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.spring;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

public class SpringSecurityContext {
    private SpringSecurityContext() {
    }

    @Nullable
    public static Token getToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication) && authentication.isAuthenticated() && authentication.getDetails() instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails authDetails = (OAuth2AuthenticationDetails)authentication.getDetails();
            String tokenValue = authDetails.getTokenValue();
            XsuaaTokenWithGrantedAuthorities xsuaaToken = new XsuaaTokenWithGrantedAuthorities(tokenValue, authentication.getAuthorities());
            if (xsuaaToken.isXsuaaToken()) {
                return xsuaaToken;
            }
            return new SapIdToken(tokenValue);
        }
        return null;
    }

    @Nullable
    public static AccessToken getAccessToken() {
        Token token = SpringSecurityContext.getToken();
        return token instanceof AccessToken ? (AccessToken)token : null;
    }

    public static void clear() {
        SecurityContextHolder.clearContext();
    }

    private static class XsuaaTokenWithGrantedAuthorities
    extends XsuaaToken {
        private final Collection<? extends GrantedAuthority> authorities;

        public XsuaaTokenWithGrantedAuthorities(String tokenValue, @Nullable Collection<? extends GrantedAuthority> authorities) {
            super(tokenValue);
            this.authorities = authorities;
        }

        @Override
        public boolean hasLocalScope(@Nonnull String scope) {
            return this.authorities.contains(new SimpleGrantedAuthority(scope));
        }
    }
}

