/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.XsuaaJkuFactory;
import com.sap.cloud.security.token.validation.validators.JsonWebKeyImpl;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.token.validation.validators.JwtSignatureValidator;
import com.sap.cloud.security.token.validation.validators.OAuth2TokenKeyServiceWithCache;
import com.sap.cloud.security.token.validation.validators.OidcConfigurationServiceWithCache;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XsuaaJwtSignatureValidator
extends JwtSignatureValidator {
    public static final Logger LOGGER = LoggerFactory.getLogger(XsuaaJwtSignatureValidator.class);
    List<XsuaaJkuFactory> jkuFactories = new ArrayList<XsuaaJkuFactory>(){
        {
            try {
                ServiceLoader.load(XsuaaJkuFactory.class).forEach(this::add);
                LOGGER.debug("loaded XsuaaJkuFactory service providers: {}", (Object)this);
            }
            catch (Exception | ServiceConfigurationError e) {
                LOGGER.warn("Unexpected failure while loading XsuaaJkuFactory service providers: {}", (Object)e.getMessage());
            }
        }
    };

    XsuaaJwtSignatureValidator(OAuth2ServiceConfiguration configuration, OAuth2TokenKeyServiceWithCache tokenKeyService, OidcConfigurationServiceWithCache oidcConfigurationService) {
        super(configuration, tokenKeyService, oidcConfigurationService);
    }

    @Override
    protected PublicKey getPublicKey(Token token, JwtSignatureAlgorithm algorithm) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        PublicKey key;
        block5: {
            key = null;
            try {
                key = this.fetchPublicKey(token, algorithm);
            }
            catch (OAuth2ServiceException | IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                if (this.configuration.hasProperty("verificationkey")) break block5;
                throw e;
            }
        }
        if (key == null && this.configuration.hasProperty("verificationkey")) {
            String fallbackKey = this.configuration.getProperty("verificationkey");
            try {
                key = JsonWebKeyImpl.createPublicKeyFromPemEncodedPublicKey(JwtSignatureAlgorithm.RS256, fallbackKey);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
                throw new IllegalArgumentException("Fallback validation key supplied via verificationkey property in service credentials could not be used: {}", ex);
            }
        }
        return key;
    }

    private PublicKey fetchPublicKey(Token token, JwtSignatureAlgorithm algorithm) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        Object jwksUri;
        String keyId;
        String string = keyId = this.configuration.isLegacyMode() ? "legacy-token-key" : token.getHeaderParameterAsString("kid");
        if (keyId == null) {
            throw new IllegalArgumentException("Token does not contain the mandatory kid header.");
        }
        String zidQueryParam = this.composeZidQueryParameter(token);
        if (this.jkuFactories.isEmpty()) {
            jwksUri = this.configuration.isLegacyMode() ? this.configuration.getUrl() + "/token_keys" : this.configuration.getProperty("uaadomain") + "/token_keys" + zidQueryParam;
        } else {
            LOGGER.info("Loaded custom JKU factory");
            jwksUri = this.jkuFactories.get(0).create(token.getTokenValue());
        }
        URI uri = URI.create((String)jwksUri);
        uri = uri.isAbsolute() ? uri : URI.create("https://" + (String)jwksUri);
        Map<String, String> params = Collections.singletonMap("X-zid", token.getAppTid());
        return this.tokenKeyService.getPublicKey(new OAuth2TokenKeyServiceWithCache.KeyParameters(algorithm, keyId, uri), params);
    }

    private String composeZidQueryParameter(Token token) {
        String zid = token.getAppTid();
        if (zid != null && !zid.isBlank()) {
            return "?zid=" + zid;
        }
        return "";
    }
}

