/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.xsuaa.Assertions;
import javax.annotation.Nullable;

public class JwtX5tValidator
implements Validator<Token> {
    public JwtX5tValidator(OAuth2ServiceConfiguration config) {
        Assertions.assertNotNull((Object)config, (String)"Service configuration must not be null");
    }

    @Override
    public ValidationResult validate(Token token) {
        if (token == null) {
            return ValidationResults.createInvalid("No token passed to validate certificate thumbprint");
        }
        String tokenX5t = JwtX5tValidator.extractCnfThumbprintFromToken(token);
        if (tokenX5t == null) {
            return ValidationResults.createInvalid("Token doesn't contain certificate thumbprint confirmation method");
        }
        Certificate clientCertificate = SecurityContext.getClientCertificate();
        if (clientCertificate == null) {
            return ValidationResults.createInvalid("Client certificate missing from SecurityContext");
        }
        String clientCertificateX5t = clientCertificate.getThumbprint();
        if (clientCertificateX5t.equals(tokenX5t)) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Certificate thumbprint validation failed with Token 'cnf' thumbprint: {} != {}", tokenX5t, clientCertificateX5t);
    }

    @Nullable
    private static String extractCnfThumbprintFromToken(Token token) {
        JsonObject cnf = token.getClaimAsJsonObject("cnf");
        return cnf == null ? null : cnf.getAsString("x5t#S256");
    }
}

