/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.token.validation.validators.JwtSignatureValidator;
import com.sap.cloud.security.token.validation.validators.OAuth2TokenKeyServiceWithCache;
import com.sap.cloud.security.token.validation.validators.OidcConfigurationServiceWithCache;
import com.sap.cloud.security.x509.X509Certificate;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.annotation.Nonnull;

class SapIdJwtSignatureValidator
extends JwtSignatureValidator {
    private boolean isTenantIdCheckEnabled = true;
    private boolean isProofTokenValidationEnabled = false;

    SapIdJwtSignatureValidator(OAuth2ServiceConfiguration configuration, OAuth2TokenKeyServiceWithCache tokenKeyService, OidcConfigurationServiceWithCache oidcConfigurationService) {
        super(configuration, tokenKeyService, oidcConfigurationService);
    }

    protected void disableTenantIdCheck() {
        this.isTenantIdCheckEnabled = false;
    }

    protected void enableProofTokenValidationCheck() {
        this.isProofTokenValidationEnabled = true;
    }

    @Override
    protected PublicKey getPublicKey(Token token, JwtSignatureAlgorithm algorithm) throws OAuth2ServiceException {
        OAuth2TokenKeyServiceWithCache.CacheKey cacheKey;
        String keyId = "default-kid";
        if (token.hasHeaderParameter("kid")) {
            keyId = token.getHeaderParameterAsString("kid");
        }
        OAuth2TokenKeyServiceWithCache.KeyParameters keyParams = new OAuth2TokenKeyServiceWithCache.KeyParameters(algorithm, keyId, this.getJwksUri(token));
        HashMap<String, String> requestParams = new HashMap<String, String>(3, 1.0f);
        requestParams.put("x-app_tid", token.getAppTid());
        requestParams.put("x-client_id", this.configuration.getClientId());
        requestParams.put("x-azp", token.getClaimAsString("azp"));
        if (this.isProofTokenValidationEnabled && !token.hasClaim("ias_apis")) {
            X509Certificate cert = (X509Certificate)SecurityContext.getClientCertificate();
            if (cert == null) {
                throw new OAuth2ServiceException("Proof token was not found");
            }
            HashMap<String, String> cacheKeyParams = new HashMap<String, String>(requestParams);
            requestParams.put("x-client_cert", cert.getPEM());
            cacheKeyParams.put("cert-sub", cert.getSubjectDN());
            cacheKey = new OAuth2TokenKeyServiceWithCache.CacheKey(keyParams.keyUri(), cacheKeyParams);
        } else {
            cacheKey = new OAuth2TokenKeyServiceWithCache.CacheKey(keyParams.keyUri(), requestParams);
        }
        try {
            return this.tokenKeyService.getPublicKey(keyParams, requestParams, cacheKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private URI getJwksUri(Token token) throws OAuth2ServiceException {
        String domain = token.getIssuer();
        if (domain == null) {
            throw new IllegalArgumentException("Token does not contain mandatory iss header.");
        }
        if (this.isTenantIdCheckEnabled && !domain.equals(String.valueOf(this.configuration.getUrl())) && token.getAppTid() == null) {
            throw new IllegalArgumentException("OIDC token must provide the app_tid claim for tenant validation when issuer is not the same as the url from the service credentials.");
        }
        return this.getOidcJwksUri(domain);
    }

    @Nonnull
    private URI getOidcJwksUri(String domain) throws OAuth2ServiceException {
        URI discoveryUri = DefaultOidcConfigurationService.getDiscoveryEndpointUri((String)domain);
        if (discoveryUri == null) {
            throw new IllegalArgumentException("OIDC .well-known discovery URI could not be constructed.");
        }
        OAuth2ServiceEndpointsProvider endpointsProvider = this.oidcConfigurationService.getOrRetrieveEndpoints(discoveryUri);
        if (endpointsProvider == null) {
            throw new OAuth2ServiceException("OIDC .well-known configuration could not be retrieved.");
        }
        URI jkuUri = endpointsProvider.getJwksUri();
        if (jkuUri == null) {
            throw new IllegalArgumentException("OIDC .well-known response did not contain JWKS URI.");
        }
        return jkuUri;
    }
}

