/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.test;

import com.nimbusds.jwt.JWTClaimsSet;
import com.sap.cloud.security.xsuaa.test.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.test.jwt.DecodedJwt;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.springframework.lang.Nullable;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.RsaSigner;
import org.springframework.security.jwt.crypto.sign.Signer;

public class JwtGenerator {
    private static final int MOCK_XSUAA_DEFAULT_PORT = 33195;
    private static final String INITIAL_JKU = "null";
    public static final Date NO_EXPIRE_DATE = new GregorianCalendar(2190, 10, 31).getTime();
    public static final int NO_EXPIRE = Integer.MAX_VALUE;
    public static final String CLIENT_ID = "sb-xsapplication!t895";
    public static final String DEFAULT_IDENTITY_ZONE_ID = "uaa";
    private static final String PRIVATE_KEY_FILE = "/spring-xsuaa-privateKey.txt";
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private final String azp;
    private final String identityZoneId;
    private final String subdomain;
    private String jku = "null";
    private String[] scopes;
    private String userName = "testuser";
    private String jwtHeaderKeyId = "legacy-token-key";
    private int port;
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private final Map<String, Object> customClaims = new LinkedHashMap<String, Object>();
    private boolean deriveAudiences = false;

    public JwtGenerator(String clientId) {
        this(clientId, 33195);
    }

    public JwtGenerator(String clientId, int port) {
        this(clientId, "", DEFAULT_IDENTITY_ZONE_ID);
        this.port = port;
    }

    public JwtGenerator(String clientId, String subdomain) {
        this(clientId, subdomain, subdomain + "-id");
    }

    public JwtGenerator(String clientId, String subdomain, String identityZoneId) {
        this.azp = clientId;
        this.subdomain = subdomain;
        this.identityZoneId = identityZoneId;
        this.port = 33195;
    }

    public JwtGenerator(int port) {
        this(CLIENT_ID, port);
    }

    public JwtGenerator() {
        this(CLIENT_ID);
    }

    public JwtGenerator setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public JwtGenerator addScopes(String ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public JwtGenerator addAttribute(String attributeName, String[] attributeValues) {
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(attributeValues));
        this.attributes.put(attributeName, valueList);
        return this;
    }

    public JwtGenerator setJwtHeaderKeyId(String keyId) {
        this.jwtHeaderKeyId = keyId;
        return this;
    }

    public JwtGenerator addCustomClaims(Map<String, Object> customClaims) {
        this.customClaims.putAll(customClaims);
        return this;
    }

    public JwtGenerator deriveAudiences(boolean shallDeriveAudiences) {
        this.deriveAudiences = shallDeriveAudiences;
        return this;
    }

    public String getTokenForAuthorizationHeader() {
        try {
            return "Bearer " + this.getToken().getTokenValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JwtGenerator setJku(String jku) {
        this.jku = jku;
        return this;
    }

    public JwtGenerator setPort(int port) {
        this.port = port;
        return this;
    }

    public org.springframework.security.oauth2.jwt.Jwt getToken() {
        JWTClaimsSet.Builder claimsSetBuilder = this.getBasicClaimSet();
        if (this.scopes != null && this.scopes.length > 0) {
            claimsSetBuilder.claim("scope", (Object)this.scopes);
            if (this.deriveAudiences) {
                claimsSetBuilder.audience(this.deriveAudiencesFromScopes(this.scopes));
            }
        }
        if (this.attributes.size() > 0) {
            claimsSetBuilder.claim("xs.user.attributes", this.attributes);
        }
        for (Map.Entry<String, Object> customClaim : this.customClaims.entrySet()) {
            claimsSetBuilder.claim(customClaim.getKey(), customClaim.getValue());
        }
        return JwtGenerator.createFromClaims(claimsSetBuilder.build().toString(), JwtGenerator.getHeaderMap(this.jwtHeaderKeyId, this.getOrCreateJku()));
    }

    private String getOrCreateJku() {
        if (INITIAL_JKU.equals(this.jku)) {
            String subdomainPart = this.subdomain != null && !this.subdomain.equals("") ? "/" + this.subdomain : "";
            return "http://localhost:" + this.port + subdomainPart + "/token_keys";
        }
        return this.jku;
    }

    private List<String> deriveAudiencesFromScopes(String[] scopes) {
        ArrayList<String> audiences = new ArrayList<String>();
        for (String scope : scopes) {
            if (!scope.contains(".")) continue;
            String aud = scope.substring(0, scope.indexOf(46));
            if (aud.isEmpty() || audiences.contains(aud)) break;
            audiences.add(aud);
        }
        return audiences;
    }

    public org.springframework.security.oauth2.jwt.Jwt createFromTemplate(String pathToTemplate) throws IOException {
        String claimsFromTemplate = IOUtils.resourceToString((String)pathToTemplate, (Charset)StandardCharsets.UTF_8);
        String claimsWithReplacements = this.replacePlaceholders(claimsFromTemplate);
        return JwtGenerator.createFromClaims(claimsWithReplacements, JwtGenerator.getHeaderMap(this.jwtHeaderKeyId, this.getOrCreateJku()));
    }

    public static org.springframework.security.oauth2.jwt.Jwt createFromFile(String pathToJwt) throws IOException {
        return JwtGenerator.convertTokenToOAuthJwt(IOUtils.resourceToString((String)pathToJwt, (Charset)StandardCharsets.UTF_8));
    }

    public static org.springframework.security.oauth2.jwt.Jwt createFromClaims(JWTClaimsSet claimsSet) {
        return JwtGenerator.createFromClaims(claimsSet.toString(), Collections.emptyMap());
    }

    public static org.springframework.security.oauth2.jwt.Jwt createFromClaims(JWTClaimsSet claimsSet, Map<String, String> tokenHeaders) {
        return JwtGenerator.createFromClaims(claimsSet.toString(), tokenHeaders);
    }

    public JWTClaimsSet.Builder getBasicClaimSet() {
        return new JWTClaimsSet.Builder().issueTime(new Date()).expirationTime(NO_EXPIRE_DATE).claim("cid", (Object)this.azp).claim("azp", (Object)this.azp).claim("origin", (Object)"userIdp").claim("user_name", (Object)this.userName).claim("email", (Object)(this.userName + "@test.org")).claim("zdn", (Object)this.subdomain).claim("zid", (Object)this.identityZoneId).claim("ext_attr", (Object)new ExternalAttrClaim()).claim("grant_type", (Object)GRANT_TYPE);
    }

    public Map<String, String> getBasicHeaders() {
        return JwtGenerator.getHeaderMap(this.jwtHeaderKeyId, this.getOrCreateJku());
    }

    private static org.springframework.security.oauth2.jwt.Jwt createFromClaims(String claims, Map<String, String> headers) {
        String token = JwtGenerator.signAndEncodeToken(claims, headers);
        return JwtGenerator.convertTokenToOAuthJwt(token);
    }

    private static Map<String, String> getHeaderMap(String jwtHeaderKeyId, String jwtKeyUrl) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (jwtHeaderKeyId != null) {
            headers.put("kid", jwtHeaderKeyId);
        }
        if (jwtKeyUrl != null) {
            headers.put("jku", jwtKeyUrl);
        }
        return headers;
    }

    private String replacePlaceholders(String claims) {
        claims = claims.replace("$exp", String.valueOf(Integer.MAX_VALUE));
        claims = claims.replace("$clientid", this.azp);
        claims = claims.replace("$azp", this.azp);
        claims = claims.replace("$zdn", this.subdomain);
        claims = claims.replace("$zid", this.identityZoneId);
        claims = claims.replace("$username", this.userName);
        return claims;
    }

    private static String signAndEncodeToken(String claims, Map<String, String> tokenHeaders) {
        RsaSigner signer = new RsaSigner(JwtGenerator.readPrivateKeyFromFile());
        Jwt jwt = JwtHelper.encode((CharSequence)claims, (Signer)signer, tokenHeaders);
        return jwt.getEncoded();
    }

    protected static String readPrivateKeyFromFile() {
        String privateKey;
        try {
            privateKey = IOUtils.resourceToString((String)PRIVATE_KEY_FILE, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("privateKey could not be read from /spring-xsuaa-privateKey.txt", e);
        }
        return privateKey;
    }

    @Nullable
    public static org.springframework.security.oauth2.jwt.Jwt convertTokenToOAuthJwt(String token) {
        return JwtGenerator.parseJwt(JwtGenerator.decodeJwt(token));
    }

    private static org.springframework.security.oauth2.jwt.Jwt parseJwt(DecodedJwt decodedJwt) {
        JSONObject payload = new JSONObject(decodedJwt.getPayload());
        JSONObject header = new JSONObject(decodedJwt.getHeader());
        return new org.springframework.security.oauth2.jwt.Jwt(decodedJwt.getEncodedToken(), Instant.ofEpochSecond(payload.optLong("iat")), Instant.ofEpochSecond(payload.getLong("exp")), header.toMap(), payload.toMap());
    }

    static DecodedJwt decodeJwt(String encodedJwtToken) {
        return Base64JwtDecoder.getInstance().decode(encodedJwtToken);
    }

    public static final class TokenHeaders {
        static final String JKU = "jku";
        static final String KID = "kid";

        private TokenHeaders() {
            throw new IllegalStateException("Utility class");
        }
    }

    public static final class TokenClaims {
        static final String CLAIM_XS_USER_ATTRIBUTES = "xs.user.attributes";
        static final String CLAIM_SCOPES = "scope";
        static final String CLAIM_CLIENT_ID = "cid";
        static final String CLAIM_AUTHORIZATION_PARTY = "azp";
        static final String CLAIM_USER_NAME = "user_name";
        static final String CLAIM_EMAIL = "email";
        static final String CLAIM_ORIGIN = "origin";
        static final String CLAIM_GRANT_TYPE = "grant_type";
        static final String CLAIM_ZDN = "zdn";
        static final String CLAIM_ZONE_ID = "zid";
        static final String CLAIM_EXTERNAL_ATTR = "ext_attr";

        private TokenClaims() {
            throw new IllegalStateException("Utility class");
        }
    }

    protected class ExternalAttrClaim {
        public String zdn;
        public String enhancer;

        protected ExternalAttrClaim() {
            this.zdn = JwtGenerator.this.subdomain;
            this.enhancer = "XSUAA";
        }
    }
}

