/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaServicesParser {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaServicesParser.class);
    private static final String TAGS = "tags";
    private static final String CREDENTIALS = "credentials";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final String XSUAA_TAG = "xsuaa";
    private final String vcapServices;
    private JSONObject credentialsJSON;

    public XsuaaServicesParser() {
        this.vcapServices = System.getenv().get(VCAP_SERVICES);
        if (this.vcapServices == null || this.vcapServices.isEmpty()) {
            logger.warn("Cannot extract XSUAA properties from VCAP_SERVICES environment variable.");
        }
    }

    public XsuaaServicesParser(InputStream inputStream) throws IOException {
        this.vcapServices = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.toCharset((String)StandardCharsets.UTF_8.name()));
        if (this.vcapServices == null || this.vcapServices.isEmpty()) {
            logger.warn("Cannot parse inputStream to extract XSUAA properties.");
        }
    }

    public XsuaaServicesParser(String vcapServicesJson) {
        this.vcapServices = vcapServicesJson;
        if (vcapServicesJson == null || vcapServicesJson.isEmpty()) {
            logger.warn("Cannot extract XSUAA properties from passed vcapServicesJson.");
        }
    }

    @Deprecated
    public Optional<String> getAttribute(String name) throws IOException {
        if (this.credentialsJSON == null) {
            this.credentialsJSON = XsuaaServicesParser.parseCredentials(this.vcapServices);
        }
        if (this.credentialsJSON != null) {
            String attributeString = this.credentialsJSON.optString(name);
            if (attributeString.isEmpty()) {
                logger.info("XSUAA VCAP_SERVICES has no attribute with name '{}'.", (Object)name);
            } else {
                return Optional.of(attributeString);
            }
        }
        return Optional.empty();
    }

    public Properties parseCredentials() throws IOException {
        Properties properties = new Properties();
        JSONObject credentialsJsonObject = XsuaaServicesParser.parseCredentials(this.vcapServices);
        if (credentialsJsonObject != null) {
            Set keys = credentialsJsonObject.keySet();
            for (String key : keys) {
                properties.put(key, credentialsJsonObject.get(key).toString());
            }
        }
        return properties;
    }

    @Nullable
    private static JSONObject parseCredentials(String vcapServices) throws IOException {
        if (vcapServices == null || vcapServices.isEmpty()) {
            logger.warn("VCAP_SERVICES could not be load.");
            return null;
        }
        try {
            JSONObject vcapServicesJSON = new JSONObject(vcapServices);
            JSONObject xsuaaBinding = XsuaaServicesParser.searchXsuaaBinding(vcapServicesJSON);
            if (Objects.nonNull(xsuaaBinding) && xsuaaBinding.has(CREDENTIALS)) {
                return (JSONObject)xsuaaBinding.get(CREDENTIALS);
            }
        }
        catch (JSONException ex) {
            throw new IOException("Error while parsing XSUAA credentials from VCAP_SERVICES: {}.", ex);
        }
        return null;
    }

    @Nullable
    private static JSONObject searchXsuaaBinding(JSONObject jsonObject) {
        for (String key : jsonObject.keySet()) {
            JSONObject foundObject = XsuaaServicesParser.getJSONObjectFromTag((JSONArray)jsonObject.get(key), XSUAA_TAG);
            if (foundObject == null) continue;
            return foundObject;
        }
        return null;
    }

    private static JSONObject getJSONObjectFromTag(JSONArray jsonArray, String tag) {
        JSONObject xsuaaBinding = null;
        for (Object value : jsonArray) {
            JSONObject binding = (JSONObject)value;
            JSONArray tags = (JSONArray)binding.get(TAGS);
            String planName = binding.optString("plan");
            boolean isApiAccessPlan = !planName.isEmpty() && planName.equals("apiaccess");
            for (Object o : tags) {
                if (!o.equals(tag) || isApiAccessPlan) continue;
                if (xsuaaBinding == null) {
                    xsuaaBinding = binding;
                    continue;
                }
                throw new IllegalStateException("Found more than one xsuaa bindings. Please consider unified broker plan.");
            }
        }
        return xsuaaBinding;
    }
}

