/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.autoconfiguration;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.client.XsuaaOAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestOperations;

@Configuration
@ConditionalOnClass(value={XsuaaTokenFlows.class})
@ConditionalOnProperty(prefix="spring.xsuaa.flows", name={"auto"}, havingValue="true", matchIfMissing=true)
public class XsuaaTokenFlowAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaTokenFlowAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={XsuaaServiceConfiguration.class, RestOperations.class})
    @ConditionalOnMissingBean
    public XsuaaTokenFlows xsuaaTokenFlows(RestOperations xsuaaRestOperations, XsuaaServiceConfiguration xsuaaServiceConfiguration) {
        logger.debug("auto-configures XsuaaTokenFlows using restOperations of type: {}", (Object)xsuaaRestOperations);
        XsuaaDefaultEndpoints endpointsProvider = new XsuaaDefaultEndpoints((OAuth2ServiceConfiguration)xsuaaServiceConfiguration);
        ClientIdentity clientCredentials = xsuaaServiceConfiguration.getClientIdentity();
        XsuaaOAuth2TokenService oAuth2TokenService = new XsuaaOAuth2TokenService(xsuaaRestOperations);
        return new XsuaaTokenFlows((OAuth2TokenService)oAuth2TokenService, (OAuth2ServiceEndpointsProvider)endpointsProvider, clientCredentials);
    }
}

