/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.xsuaa.extractor.AuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.token.XsuaaToken;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LocalAuthoritiesExtractor
implements AuthoritiesExtractor {
    protected String appId;

    public LocalAuthoritiesExtractor(String appId) {
        this.appId = appId;
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities(XsuaaToken jwt) {
        HashSet<String> scopeAuthorities = new HashSet<String>();
        scopeAuthorities.addAll(this.getScopes(jwt, this.appId));
        Stream<SimpleGrantedAuthority> authorities = Stream.of(scopeAuthorities).flatMap(Collection::stream);
        return authorities.map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    protected Set<String> getScopes(XsuaaToken jwt, String appId) {
        Collection<String> scopes = jwt.getScopes();
        if (scopes == null) {
            return Collections.emptySet();
        }
        return scopes.stream().filter(scope -> scope.startsWith(appId + ".")).map(scope -> scope.replaceFirst(appId + ".", "")).collect(Collectors.toSet());
    }
}

