/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaOAuth2TokenService;
import com.sap.cloud.security.xsuaa.extractor.AuthenticationInformationExtractor;
import com.sap.cloud.security.xsuaa.extractor.AuthenticationMethod;
import com.sap.cloud.security.xsuaa.extractor.DefaultAuthenticationInformationExtractor;
import com.sap.cloud.security.xsuaa.extractor.IasXsuaaExchangeBroker;
import com.sap.cloud.security.xsuaa.extractor.TokenBroker;
import com.sap.cloud.security.xsuaa.extractor.TokenBrokerException;
import com.sap.cloud.security.xsuaa.extractor.TokenUrlUtils;
import com.sap.cloud.security.xsuaa.extractor.TokenUtil;
import com.sap.cloud.security.xsuaa.extractor.UaaTokenBroker;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.StringUtils;

public class TokenBrokerResolver
implements BearerTokenResolver {
    private static final Logger logger = LoggerFactory.getLogger(TokenBrokerResolver.class);
    private static final String AUTH_BASIC_CREDENTIAL = "BASIC";
    private static final String AUTH_HEADER = "Authorization";
    private static final String OAUTH_TOKEN_PATH = "/oauth/token";
    private static final String AUTH_BEARER = "bearer";
    private final XsuaaServiceConfiguration configuration;
    private final Cache tokenCache;
    private final TokenBroker tokenBroker;
    private AuthenticationInformationExtractor authenticationConfig;
    private IasXsuaaExchangeBroker iasXsuaaExchangeBroker;

    @Deprecated
    public TokenBrokerResolver(XsuaaServiceConfiguration configuration, Cache tokenCache, TokenBroker tokenBroker, AuthenticationInformationExtractor authenticationConfig) {
        this.configuration = configuration;
        this.tokenCache = tokenCache;
        this.tokenBroker = tokenBroker;
        this.authenticationConfig = authenticationConfig;
    }

    public TokenBrokerResolver(XsuaaServiceConfiguration configuration, Cache tokenCache, OAuth2TokenService tokenService, AuthenticationInformationExtractor authenticationConfig) {
        this.configuration = configuration;
        this.tokenCache = tokenCache;
        this.tokenBroker = new UaaTokenBroker(tokenService);
        this.authenticationConfig = authenticationConfig;
        if (TokenUtil.isIasToXsuaaXchangeEnabled()) {
            this.iasXsuaaExchangeBroker = new IasXsuaaExchangeBroker(configuration, tokenService);
        }
    }

    @Deprecated
    public TokenBrokerResolver(XsuaaServiceConfiguration configuration, Cache tokenCache, AuthenticationMethod ... authenticationMethods) {
        this(configuration, tokenCache, (OAuth2TokenService)new XsuaaOAuth2TokenService(), (AuthenticationInformationExtractor)new DefaultAuthenticationInformationExtractor(authenticationMethods));
    }

    public String resolve(HttpServletRequest request) {
        try {
            return this.extractToken(request);
        }
        catch (TokenBrokerException e) {
            logger.warn("Error obtaining token: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String extractToken(HttpServletRequest request) throws TokenBrokerException {
        List<AuthenticationMethod> authenticationMethods = this.authenticationConfig.getAuthenticationMethods(request);
        this.checkTypes(authenticationMethods);
        String oauthTokenUrl = this.getOAuthTokenUrl(request);
        ClientCredentials clientIdentity = new ClientCredentials(this.configuration.getClientId(), this.configuration.getClientSecret());
        for (AuthenticationMethod credentialType : authenticationMethods) {
            for (String authHeaderValue : Collections.list(request.getHeaders(AUTH_HEADER))) {
                String token = this.getBrokerToken(credentialType, authHeaderValue, oauthTokenUrl, (ClientIdentity)clientIdentity);
                if (!StringUtils.hasText((String)token)) continue;
                return token;
            }
        }
        return null;
    }

    private void checkTypes(List<AuthenticationMethod> authenticationMethods) {
        if (authenticationMethods.contains((Object)AuthenticationMethod.BASIC) && authenticationMethods.contains((Object)AuthenticationMethod.CLIENT_CREDENTIALS)) {
            throw new IllegalArgumentException("Use either CLIENT_CREDENTIALS or BASIC");
        }
    }

    private String getOAuthTokenUrl(HttpServletRequest request) {
        String uaaUrl = this.configuration.getUaaUrl();
        String uaaDomain = this.configuration.getUaaDomain();
        Optional<String> subdomainResult = this.authenticationConfig.getSubdomain(request);
        String oauthTokenUrl = subdomainResult.isPresent() ? TokenUrlUtils.getMultiTenancyUrl(OAUTH_TOKEN_PATH, uaaUrl, uaaDomain, subdomainResult.get()) : TokenUrlUtils.getOauthTokenUrl(OAUTH_TOKEN_PATH, uaaUrl, uaaDomain);
        return oauthTokenUrl;
    }

    private String getBrokerToken(AuthenticationMethod credentialType, String authHeaderValue, String oauthTokenUrl, ClientIdentity clientIdentity) throws TokenBrokerException {
        switch (credentialType) {
            case OAUTH2: {
                DecodedJwt decodedJwt;
                String oAuth2token = this.extractAuthenticationFromHeader(AUTH_BEARER, authHeaderValue);
                if (oAuth2token == null) break;
                if (TokenUtil.isIasToXsuaaXchangeEnabled() && !TokenUtil.isXsuaaToken(decodedJwt = TokenUtil.decodeJwt(oAuth2token))) {
                    try {
                        return this.iasXsuaaExchangeBroker.doIasXsuaaXchange(decodedJwt);
                    }
                    catch (JSONException e) {
                        logger.error("Couldn't decode the token: {}", (Object)e.getMessage());
                    }
                }
                return oAuth2token;
            }
            case BASIC: {
                String basicAuthHeader = this.extractAuthenticationFromHeader(AUTH_BASIC_CREDENTIAL, authHeaderValue);
                ClientCredentials userCredentialsFromHeader = this.getCredentialsFromBasicAuthorizationHeader(basicAuthHeader);
                if (userCredentialsFromHeader == null) break;
                String cacheKey = this.createSecureHash(oauthTokenUrl, clientIdentity.toString(), userCredentialsFromHeader.toString());
                String cachedToken = (String)this.tokenCache.get((Object)cacheKey, String.class);
                if (cachedToken != null) {
                    logger.debug("return (basic) access token for {} from cache", (Object)cacheKey);
                    return cachedToken;
                }
                String token = this.tokenBroker.getAccessTokenFromPasswordCredentials(oauthTokenUrl, clientIdentity.getId(), clientIdentity.getSecret(), userCredentialsFromHeader.getId(), userCredentialsFromHeader.getSecret());
                this.tokenCache.put((Object)cacheKey, (Object)token);
                return token;
            }
            case CLIENT_CREDENTIALS: {
                String clientCredentialsAuthHeader = this.extractAuthenticationFromHeader(AUTH_BASIC_CREDENTIAL, authHeaderValue);
                ClientCredentials clientCredentialsFromHeader = this.getCredentialsFromBasicAuthorizationHeader(clientCredentialsAuthHeader);
                if (clientCredentialsFromHeader == null) break;
                String cacheKey = this.createSecureHash(oauthTokenUrl, clientCredentialsFromHeader.toString());
                String cachedToken = (String)this.tokenCache.get((Object)cacheKey, String.class);
                if (cachedToken != null) {
                    logger.debug("return (client-credentials) access token for {} from cache", (Object)cacheKey);
                    return cachedToken;
                }
                String token = this.tokenBroker.getAccessTokenFromClientCredentials(oauthTokenUrl, clientCredentialsFromHeader.getId(), clientCredentialsFromHeader.getSecret());
                this.tokenCache.put((Object)cacheKey, (Object)token);
                return token;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private ClientCredentials getCredentialsFromBasicAuthorizationHeader(@Nullable String basicAuthHeader) {
        String[] credentialDetails;
        if (basicAuthHeader == null) {
            return null;
        }
        byte[] decodedBytes = Base64.getDecoder().decode(basicAuthHeader.getBytes(StandardCharsets.UTF_8));
        String pair = new String(decodedBytes, StandardCharsets.UTF_8);
        if (pair.contains(":") && (credentialDetails = pair.split(":", 2)).length == 2) {
            return new ClientCredentials(credentialDetails[0], credentialDetails[1]);
        }
        return null;
    }

    private String createSecureHash(String ... keys) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            for (String k : keys) {
                messageDigest.update(k.getBytes(StandardCharsets.UTF_8));
            }
            byte[] hash = messageDigest.digest();
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("No such Algorithm", e);
        }
    }

    private String extractAuthenticationFromHeader(String authenticationMethod, String authHeaderValue) {
        if (authHeaderValue.toLowerCase().startsWith(authenticationMethod.toLowerCase())) {
            String authorizationHeaderValue = authHeaderValue.substring(authenticationMethod.length()).trim();
            int index = authorizationHeaderValue.indexOf(44);
            if (index > 0) {
                authorizationHeaderValue = authorizationHeaderValue.substring(0, index);
            }
            return authorizationHeaderValue;
        }
        return null;
    }

    public AuthenticationInformationExtractor getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void setAuthenticationConfig(AuthenticationInformationExtractor authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    @Nullable
    private String parseSubdomainFromOIDCToken(String encodedJwtToken) {
        String claims = new Base64JwtDecoder().decode(encodedJwtToken).getPayload();
        try {
            JSONObject rootObject = new JSONObject(claims);
            return rootObject.getString("zdn");
        }
        catch (JSONException e) {
            return null;
        }
    }
}

