/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token;

import com.sap.cloud.security.token.InvalidTokenException;
import com.sap.cloud.security.xsuaa.token.Token;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class XsuaaToken
extends Jwt
implements Token {
    static final String GRANTTYPE_SAML2BEARER = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    static final String UNIQUE_USER_NAME_FORMAT = "user/%s/%s";
    static final String UNIQUE_CLIENT_NAME_FORMAT = "client/%s";
    static final String CLAIM_SERVICEINSTANCEID = "serviceinstanceid";
    static final String CLAIM_ADDITIONAL_AZ_ATTR = "az_attr";
    static final String CLAIM_EXTERNAL_ATTR = "ext_attr";
    static final String CLAIM_EXTERNAL_CONTEXT = "ext_ctx";
    static final String CLAIM_SUBACCOUNT_ID = "subaccountid";
    private static final long serialVersionUID = -836947635254353927L;
    private static final Logger logger = LoggerFactory.getLogger(XsuaaToken.class);
    private Collection<GrantedAuthority> authorities = Collections.emptyList();

    protected XsuaaToken(Jwt jwt) {
        super(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getHeaders(), jwt.getClaims());
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public Date getExpirationDate() {
        return this.getExpiresAt() != null ? Date.from(this.getExpiresAt()) : null;
    }

    @Override
    public Instant getExpiration() {
        return this.getExpiresAt();
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        if ("client_credentials".equals(this.getGrantType()) || "client_x509".equalsIgnoreCase(this.getGrantType())) {
            return String.format(UNIQUE_CLIENT_NAME_FORMAT, this.getClientId());
        }
        return XsuaaToken.getUniquePrincipalName(this.getOrigin(), this.getLogonName());
    }

    public boolean isAccountNonExpired() {
        JwtTimestampValidator validator = new JwtTimestampValidator();
        return !validator.validate((Jwt)this).hasErrors();
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        JwtTimestampValidator validator = new JwtTimestampValidator();
        return validator.validate((Jwt)this).hasErrors();
    }

    public boolean isEnabled() {
        return false;
    }

    @Nullable
    public static String getUniquePrincipalName(String origin, String userLoginName) {
        if (origin == null) {
            logger.warn("Origin claim not set in JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        if (userLoginName == null) {
            logger.warn("User login name claim not set in JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        if (origin.contains("/")) {
            logger.warn("Illegal '/' character detected in origin claim of JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        return String.format(UNIQUE_USER_NAME_FORMAT, origin, userLoginName);
    }

    @Override
    @Nullable
    public String getLogonName() {
        return this.getClaimAsString("user_name");
    }

    @Override
    @Nullable
    public String getClientId() {
        String clientId = this.getClaimAsString("azp");
        if (clientId == null || clientId.trim().isEmpty()) {
            List audiences = this.getAudience();
            if (audiences != null && audiences.size() == 1) {
                return (String)audiences.get(0);
            }
            if (this.hasClaim("cid") && !this.getClaimAsString("cid").trim().isEmpty()) {
                logger.warn("usage of 'cid' claim is deprecated and should be replaced by 'azp' or 'aud' claims");
                return this.getClaimAsString("cid");
            }
            logger.error("Couldn't get client id. Invalid authorized party or audience claims.");
            throw new InvalidTokenException("Couldn't get client id. Invalid authorized party or audience claims.");
        }
        return clientId;
    }

    @Override
    public String getGivenName() {
        String externalAttribute = this.getStringAttributeFromClaim("given_name", CLAIM_EXTERNAL_ATTR);
        return externalAttribute != null ? externalAttribute : this.getClaimAsString("given_name");
    }

    @Override
    @Nullable
    public String getFamilyName() {
        String externalAttribute = this.getStringAttributeFromClaim("family_name", CLAIM_EXTERNAL_ATTR);
        return externalAttribute != null ? externalAttribute : this.getClaimAsString("family_name");
    }

    @Override
    public String getEmail() {
        return this.getClaimAsString("email");
    }

    @Override
    public String getOrigin() {
        return this.getClaimAsString("origin");
    }

    @Override
    public String getGrantType() {
        return this.getClaimAsString("grant_type");
    }

    @Override
    public String getSubaccountId() {
        String externalAttribute = this.getStringAttributeFromClaim(CLAIM_SUBACCOUNT_ID, CLAIM_EXTERNAL_ATTR);
        return !StringUtils.hasText((String)externalAttribute) ? this.getClaimAsString("zid") : externalAttribute;
    }

    @Override
    public String getZoneId() {
        return this.getClaimAsString("zid");
    }

    @Override
    public String getSubdomain() {
        return this.getStringAttributeFromClaim("zdn", CLAIM_EXTERNAL_ATTR);
    }

    public String toString() {
        return this.getUsername();
    }

    @Override
    @Nullable
    public String[] getXSUserAttribute(String attributeName) {
        String[] attributeValue = this.getStringListAttributeFromClaim(attributeName, CLAIM_EXTERNAL_CONTEXT);
        return attributeValue != null ? attributeValue : this.getStringListAttributeFromClaim(attributeName, "xs.user.attributes");
    }

    @Override
    public String getAdditionalAuthAttribute(String attributeName) {
        return this.getStringAttributeFromClaim(attributeName, CLAIM_ADDITIONAL_AZ_ATTR);
    }

    @Override
    public String getCloneServiceInstanceId() {
        return this.getStringAttributeFromClaim(CLAIM_SERVICEINSTANCEID, CLAIM_EXTERNAL_ATTR);
    }

    @Override
    public String getAppToken() {
        return this.getTokenValue();
    }

    @Override
    public Collection<String> getScopes() {
        List<String> scopesList = this.getClaimAsStringList("scope");
        return scopesList != null ? scopesList : Collections.emptyList();
    }

    void setAuthorities(Collection<GrantedAuthority> authorities) {
        Assert.notNull(authorities, (String)"authorities are required");
        this.authorities = authorities;
    }

    private String getStringAttributeFromClaim(String attributeName, String claimName) {
        Map attribute = this.getClaimAsMap(claimName);
        return attribute == null ? null : (String)attribute.get(attributeName);
    }

    private String[] getStringListAttributeFromClaim(String attributeName, String claimName) {
        String[] attributeValues = null;
        Map claimMap = this.getClaimAsMap(claimName);
        if (claimMap == null) {
            logger.debug("Claim '{}' not found. Returning null.", (Object)claimName);
            return attributeValues;
        }
        JSONArray attributeJsonArray = new JSONArray((Collection)((ArrayList)claimMap.get(attributeName)));
        if (attributeJsonArray != null) {
            attributeValues = new String[attributeJsonArray.length()];
            for (int i = 0; i < attributeJsonArray.length(); ++i) {
                attributeValues[i] = (String)attributeJsonArray.get(i);
            }
        }
        if (attributeValues == null) {
            logger.debug("Attribute '{}' in claim '{}' not found. Returning null.", (Object)attributeName, (Object)claimName);
            return attributeValues;
        }
        return attributeValues;
    }
}

