/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token.authentication;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServicesParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class XsuaaAudienceValidator
implements OAuth2TokenValidator<Jwt> {
    private Map<String, String> appIdClientIdMap = new HashMap<String, String>();
    private final Logger logger = LoggerFactory.getLogger(XsuaaServicesParser.class);

    public XsuaaAudienceValidator(XsuaaServiceConfiguration xsuaaServiceConfiguration) {
        Assert.notNull((Object)xsuaaServiceConfiguration, (String)"'xsuaaServiceConfiguration' is required");
        this.appIdClientIdMap.put(xsuaaServiceConfiguration.getAppId(), xsuaaServiceConfiguration.getClientId());
    }

    public void configureAnotherXsuaaInstance(String appId, String clientId) {
        Assert.notNull((Object)appId, (String)"'appId' is required");
        Assert.notNull((Object)clientId, (String)"'clientId' is required");
        this.appIdClientIdMap.putIfAbsent(appId, clientId);
        this.logger.info("configured XsuaaAudienceValidator with appId {} and clientId {}", (Object)appId, (Object)clientId);
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        String tokenClientId = token.getClaimAsString("cid");
        if (!StringUtils.hasText((String)tokenClientId)) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_client", "Jwt token must contain 'cid' (client_id)", null)});
        }
        Set<String> allowedAudiences = XsuaaAudienceValidator.getAllowedAudiences(token);
        for (Map.Entry<String, String> xsuaaConfig : this.appIdClientIdMap.entrySet()) {
            if (!this.checkMatch(xsuaaConfig.getKey(), xsuaaConfig.getValue(), tokenClientId, allowedAudiences)) continue;
            return OAuth2TokenValidatorResult.success();
        }
        String description = String.format("Jwt token with allowed audiences %s matches none of these: %s", allowedAudiences, this.appIdClientIdMap.keySet().toString());
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_client", description, null)});
    }

    private boolean checkMatch(String appId, String clientId, String tokenClientId, Set<String> allowedAudiences) {
        if (clientId.equals(tokenClientId) || appId.contains("!b") && tokenClientId.endsWith("|" + appId)) {
            return true;
        }
        return allowedAudiences.contains(appId);
    }

    static Set<String> getAllowedAudiences(Jwt token) {
        String aud;
        HashSet<String> allAudiences = new HashSet<String>();
        List tokenAudiences = token.getAudience();
        if (tokenAudiences != null) {
            for (String audience : tokenAudiences) {
                aud = audience.contains(".") ? audience.substring(0, audience.indexOf(46)) : audience;
                allAudiences.add(aud);
            }
        }
        if (allAudiences.isEmpty()) {
            for (String scope : XsuaaAudienceValidator.getScopes(token)) {
                if (!scope.contains(".")) continue;
                aud = scope.substring(0, scope.indexOf(46));
                allAudiences.add(aud);
            }
        }
        allAudiences.remove("");
        return allAudiences;
    }

    static List<String> getScopes(Jwt token) {
        List<String> scopes = token.getClaimAsStringList("scope");
        return scopes != null ? scopes : Collections.emptyList();
    }
}

