/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import java.net.URI;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XsuaaServiceConfigurationDefault
implements XsuaaServiceConfiguration {
    static final String VCAP_SERVICES_CREDENTIALS = "xsuaa credentials from VCAP_SERVICES/secret must not be null";
    @Value(value="${xsuaa.clientid:}")
    private String clientId;
    @Value(value="${xsuaa.clientsecret:}")
    private String clientSecret;
    @Value(value="${xsuaa.url:}")
    private String uaaUrl;
    @Value(value="${xsuaa.uaadomain:#{null}}")
    private String uaadomain;
    @Value(value="${xsuaa.xsappname:}")
    private String appid;
    @Value(value="${xsuaa.key:}")
    private String privateKey;
    @Value(value="${xsuaa.certificate:}")
    private String certificate;
    @Value(value="${xsuaa.verificationkey:}")
    private String verificationKey;
    @Value(value="${xsuaa.credential-type:#{null}}")
    private String credentialType;
    @Value(value="${xsuaa.certurl:#{null}}")
    private String certUrl;

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getUaaUrl() {
        return this.uaaUrl;
    }

    @Override
    public String getAppId() {
        return this.appid;
    }

    @Override
    public String getUaaDomain() {
        return this.uaadomain;
    }

    @Override
    public String getVerificationKey() {
        return this.verificationKey;
    }

    public CredentialType getCredentialType() {
        return CredentialType.from((String)this.credentialType);
    }

    public URI getCertUrl() {
        return URI.create(this.certUrl);
    }

    @Override
    public ClientIdentity getClientIdentity() {
        ClientCertificate identity = new ClientCertificate(this.certificate, this.privateKey, this.getClientId());
        if (!identity.isValid()) {
            identity = new ClientCredentials(this.getClientId(), this.getClientSecret());
        }
        return identity;
    }

    @Override
    public String getProperty(String name) {
        return Objects.requireNonNull(Environments.getCurrent().getXsuaaConfiguration(), VCAP_SERVICES_CREDENTIALS).getProperty(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return Objects.requireNonNull(Environments.getCurrent().getXsuaaConfiguration(), VCAP_SERVICES_CREDENTIALS).hasProperty(name);
    }
}

