/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa;

import com.sap.cloud.security.config.Environment;
import com.sap.cloud.security.config.Environments;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class XsuaaServicePropertySourceFactory
implements PropertySourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaServicePropertySourceFactory.class);
    protected static final String XSUAA_PREFIX = "xsuaa.";
    private static final String XSUAA_PROPERTIES_KEY = "xsuaa";
    public static final String CLIENT_ID = "xsuaa.clientid";
    public static final String CLIENT_SECRET = "xsuaa.clientsecret";
    public static final String URL = "xsuaa.url";
    public static final String UAA_DOMAIN = "xsuaa.uaadomain";
    private static final List<String> XSUAA_ATTRIBUTES = Arrays.asList("clientid", "clientsecret", "sburl", "tenantid", "tenantmode", "uaadomain", "url", "verificationkey", "xsappname", "certificate", "key", "credential-type", "certurl");

    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        Properties properties = new Properties();
        Environment environment = resource.getResource() instanceof InputStreamResource || resource.getResource().getFilename() != null && !resource.getResource().getFilename().isEmpty() ? Environments.readFromInput((InputStream)resource.getResource().getInputStream()) : Environments.getCurrent();
        if (environment.getNumberOfXsuaaConfigurations() > 1 && environment.getXsuaaConfigurationForTokenExchange() != null) {
            throw new IllegalStateException("Found more than one xsuaa bindings. Please consider unified broker plan or use com.sap.cloud.security:spring-security client library.");
        }
        if (environment.getXsuaaConfiguration() != null) {
            for (String key : XSUAA_ATTRIBUTES) {
                if (!environment.getXsuaaConfiguration().hasProperty(key)) continue;
                properties.put(key, environment.getXsuaaConfiguration().getProperty(key));
            }
        }
        logger.info("Parsed {} XSUAA properties.", (Object)properties.size());
        return XsuaaServicePropertySourceFactory.create(XSUAA_PROPERTIES_KEY, properties);
    }

    public static PropertySource create(String name, Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            if (XSUAA_ATTRIBUTES.contains(property)) {
                properties.setProperty(XSUAA_PREFIX + property, properties.remove(property).toString());
                continue;
            }
            logger.info("Property {} is not considered as part of PropertySource.", (Object)property);
        }
        return new PropertiesPropertySource(name, properties);
    }
}

