/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.xsuaa.extractor.AuthenticationInformationExtractor;
import com.sap.cloud.security.xsuaa.extractor.AuthenticationMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class DefaultAuthenticationInformationExtractor
implements AuthenticationInformationExtractor {
    private static final String SUBDOMAIN_HEADER = "X-Identity-Zone-Subdomain";
    private final String subDomain;
    private List<AuthenticationMethod> authenticationMethods = Arrays.asList(AuthenticationMethod.BASIC, AuthenticationMethod.OAUTH2);

    public DefaultAuthenticationInformationExtractor() {
        this.subDomain = null;
    }

    public DefaultAuthenticationInformationExtractor(String subDomain) {
        this.subDomain = subDomain;
    }

    public DefaultAuthenticationInformationExtractor(AuthenticationMethod ... authenticationMethods) {
        this((String)null, authenticationMethods);
    }

    public DefaultAuthenticationInformationExtractor(String subDomain, AuthenticationMethod ... authenticationMethods) {
        this.subDomain = subDomain;
        this.authenticationMethods = Arrays.asList(authenticationMethods);
    }

    @Override
    public Optional<String> getSubdomain() {
        if (this.subDomain != null && !this.subDomain.trim().isEmpty()) {
            return Optional.of(this.subDomain);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getSubdomain(HttpServletRequest request) {
        Optional<String> subdomainResult = this.getSubdomain();
        if (subdomainResult.isPresent()) {
            return subdomainResult;
        }
        Objects.requireNonNull(request, "Request must not be null");
        String subdomainParam = request.getParameter(SUBDOMAIN_HEADER);
        String subdomainHeader = request.getHeader(SUBDOMAIN_HEADER);
        if (!Objects.isNull(subdomainParam)) {
            return Optional.of(subdomainParam);
        }
        if (!Objects.isNull(subdomainHeader)) {
            return Optional.of(subdomainHeader);
        }
        return Optional.empty();
    }

    @Override
    public List<AuthenticationMethod> getAuthenticationMethods(HttpServletRequest request) {
        return this.authenticationMethods;
    }
}

