/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.client.XsuaaOAuth2TokenService;
import com.sap.cloud.security.xsuaa.extractor.IasToken;
import com.sap.cloud.security.xsuaa.extractor.TokenUtil;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;

public class IasXsuaaExchangeBroker
implements BearerTokenResolver {
    private static final Logger logger = LoggerFactory.getLogger(IasXsuaaExchangeBroker.class);
    private final XsuaaTokenFlows xsuaaTokenFlows;
    private static final String AUTH_HEADER = "Authorization";

    public IasXsuaaExchangeBroker(XsuaaTokenFlows xsuaaTokenFlows) {
        this.xsuaaTokenFlows = xsuaaTokenFlows;
    }

    public IasXsuaaExchangeBroker(OAuth2ServiceConfiguration configuration, OAuth2TokenService tokenService) {
        ClientIdentity clientIdentity = configuration.getClientIdentity();
        logger.debug("Initializing XsuaaTokenFlow ({} based authentication)", (Object)(configuration.getCredentialType() == CredentialType.X509 ? "certificate" : "client secret"));
        this.xsuaaTokenFlows = new XsuaaTokenFlows(tokenService, (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(configuration), clientIdentity);
    }

    @Deprecated
    public IasXsuaaExchangeBroker(OAuth2ServiceConfiguration configuration) {
        this(configuration, (OAuth2TokenService)new XsuaaOAuth2TokenService());
    }

    @Nullable
    public String resolve(HttpServletRequest request) {
        String oAuth2Token = this.extractTokenFromRequest(request);
        if (oAuth2Token == null) {
            logger.info("Request did not have Authorization header containing bearer token, skipping token exchange.");
            return null;
        }
        try {
            DecodedJwt decodedJwt;
            if (TokenUtil.isIasToXsuaaXchangeEnabled() && !TokenUtil.isXsuaaToken(decodedJwt = TokenUtil.decodeJwt(oAuth2Token))) {
                return this.doIasXsuaaXchange(decodedJwt);
            }
        }
        catch (JSONException e) {
            logger.error("Couldn't decode the token: {}", (Object)e.getMessage());
        }
        return oAuth2Token;
    }

    @Nullable
    String doIasXsuaaXchange(DecodedJwt decodedJwt) {
        try {
            return this.xsuaaTokenFlows.userTokenFlow().token(this.createToken(decodedJwt)).execute().getAccessToken();
        }
        catch (TokenFlowException e) {
            logger.error("Xsuaa token request failed {}", (Object)e.getMessage());
            return null;
        }
    }

    private Token createToken(DecodedJwt decodedJwt) {
        Jwt jwt = TokenUtil.parseJwt(decodedJwt);
        return new IasToken(jwt);
    }

    @Nullable
    private String extractTokenFromRequest(HttpServletRequest request) {
        String authHeader = request.getHeader(AUTH_HEADER);
        if (authHeader != null && authHeader.toLowerCase().startsWith("bearer")) {
            return authHeader.substring("bearer".length()).trim();
        }
        return null;
    }
}

