/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa;

import com.sap.cloud.security.xsuaa.XsuaaServicesParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class XsuaaServicePropertySourceFactory
implements PropertySourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaServicePropertySourceFactory.class);
    protected static final String XSUAA_PREFIX = "xsuaa.";
    private static final String XSUAA_PROPERTIES_KEY = "xsuaa";
    public static final String CLIENT_ID = "xsuaa.clientid";
    public static final String CLIENT_SECRET = "xsuaa.clientsecret";
    public static final String URL = "xsuaa.url";
    public static final String UAA_DOMAIN = "xsuaa.uaadomain";
    private static final List<String> XSUAA_ATTRIBUTES = Arrays.asList("clientid", "clientsecret", "identityzoneid", "sburl", "tenantid", "tenantmode", "uaadomain", "url", "verificationkey", "xsappname", "certificate", "key");

    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        Properties properties = null;
        XsuaaServicesParser vcapServicesParser = null;
        vcapServicesParser = resource != null && resource.getResource().getFilename() != null && !resource.getResource().getFilename().isEmpty() ? new XsuaaServicesParser(resource.getResource().getInputStream()) : new XsuaaServicesParser();
        properties = vcapServicesParser.parseCredentials();
        logger.info("Parsed {} XSUAA properties.", (Object)properties.size());
        return XsuaaServicePropertySourceFactory.create(XSUAA_PROPERTIES_KEY, properties);
    }

    public static PropertySource create(String name, Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            if (XSUAA_ATTRIBUTES.contains(property)) {
                properties.setProperty(XSUAA_PREFIX + property, properties.remove(property).toString());
                continue;
            }
            logger.info("Property {} is not considered as part of PropertySource.", (Object)property);
        }
        return new PropertiesPropertySource(name, properties);
    }
}

