/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.autoconfiguration;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfigurationDefault;
import com.sap.cloud.security.xsuaa.XsuaaServicePropertySourceFactory;
import com.sap.cloud.security.xsuaa.extractor.TokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={Jwt.class})
@ConditionalOnProperty(prefix="spring.xsuaa", name={"auto"}, havingValue="true", matchIfMissing=true)
public class XsuaaAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RestOperations xsuaaRestOperations() {
        logger.info("auto-configures RestOperations for xsuaa requests");
        return new RestTemplate();
    }

    private static class PropertyConditions
    extends AllNestedConditions {
        public PropertyConditions() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.xsuaa", name={"disable-default-property-source"}, havingValue="false", matchIfMissing=true)
        static class DisableDefaultPropertySourceCondition {
            DisableDefaultPropertySourceCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.xsuaa", name={"multiple-bindings"}, havingValue="false", matchIfMissing=true)
        static class MultipleBindingsCondition {
            MultipleBindingsCondition() {
            }
        }
    }

    @Configuration
    @PropertySource(factory=XsuaaServicePropertySourceFactory.class, value={""})
    @Conditional(value={PropertyConditions.class})
    public static class XsuaaServiceAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={XsuaaServiceConfiguration.class})
        public XsuaaServiceConfiguration xsuaaServiceConfiguration() {
            logger.info("auto-configures XsuaaServiceConfigurationDefault");
            return new XsuaaServiceConfigurationDefault();
        }

        @Bean
        public TokenUtil tokenUtil() {
            return new TokenUtil();
        }
    }
}

