/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.Token;
import java.security.Principal;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.oauth2.jwt.Jwt;

class IasToken
implements Token {
    private Jwt decodedToken;

    public IasToken(Jwt jwt) {
        this.decodedToken = jwt;
    }

    @Nullable
    public String getHeaderParameterAsString(@Nonnull String headerName) {
        return this.decodedToken.getHeaders().get(headerName).toString();
    }

    public boolean hasHeaderParameter(@Nonnull String headerName) {
        return this.decodedToken.getHeaders().containsValue(headerName);
    }

    public boolean hasClaim(@Nonnull String claimName) {
        return this.decodedToken.containsClaim(claimName);
    }

    @Nullable
    public String getClaimAsString(@Nonnull String claimName) {
        return this.decodedToken.getClaimAsString(claimName);
    }

    public List<String> getClaimAsStringList(@Nonnull String claimName) {
        return this.decodedToken.getClaimAsStringList(claimName);
    }

    @Nullable
    public JsonObject getClaimAsJsonObject(@Nonnull String claimName) {
        return (JsonObject)this.decodedToken.getClaim(claimName);
    }

    @Nullable
    public Instant getExpiration() {
        return this.decodedToken.getExpiresAt();
    }

    public boolean isExpired() {
        return Objects.requireNonNull(this.decodedToken.getExpiresAt(), "Token expiration time is missing").isBefore(Instant.now());
    }

    @Nullable
    public Instant getNotBefore() {
        return this.decodedToken.getNotBefore();
    }

    public String getTokenValue() {
        return this.decodedToken.getTokenValue();
    }

    public Principal getPrincipal() {
        return null;
    }

    public Service getService() {
        return Service.IAS;
    }

    public Set<String> getAudiences() {
        return new LinkedHashSet<String>(this.getClaimAsStringList("aud"));
    }

    public String getZoneId() {
        return this.decodedToken.getClaimAsString("zone_uuid");
    }

    public String getClientId() {
        return this.decodedToken.getClaimAsString("user_uuid");
    }
}

