/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.autoconfiguration;

import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfigurationDefault;
import com.sap.cloud.security.xsuaa.XsuaaServicePropertySourceFactory;
import com.sap.cloud.security.xsuaa.extractor.TokenUtil;
import com.sap.cloud.security.xsuaa.token.authentication.httpclient.SpringHttpClientFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={Jwt.class})
@ConditionalOnProperty(prefix="spring.xsuaa", name={"auto"}, havingValue="true", matchIfMissing=true)
public class XsuaaAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaAutoConfiguration.class);

    @Bean
    @Conditional(value={OnSecretCredentialTypeCondition.class, NoClientCertificateCondition.class})
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={XsuaaServiceConfiguration.class})
    public RestOperations xsuaaRestOperations() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.apache.hc.client5.http.impl.classic.CloseableHttpClient"})
    @ConditionalOnBean(value={XsuaaServiceConfiguration.class})
    public RestOperations xsuaaMtlsRestOperations(XsuaaServiceConfiguration xsuaaServiceConfiguration) {
        return SpringHttpClientFactory.createRestTemplate(xsuaaServiceConfiguration.getClientIdentity());
    }

    private static class NoClientCertificateCondition
    implements Condition {
        private NoClientCertificateCondition() {
        }

        public boolean matches(ConditionContext context, @Nonnull AnnotatedTypeMetadata metadata) {
            return context.getEnvironment().getProperty("xsuaa.certificate") == null && context.getEnvironment().getProperty("xsuaa.key") == null;
        }
    }

    private static class OnSecretCredentialTypeCondition
    implements Condition {
        private OnSecretCredentialTypeCondition() {
        }

        public boolean matches(ConditionContext context, @Nonnull AnnotatedTypeMetadata metadata) {
            CredentialType credentialType = CredentialType.from((String)context.getEnvironment().getProperty("xsuaa.credential-type"));
            return credentialType == CredentialType.BINDING_SECRET || credentialType == CredentialType.INSTANCE_SECRET || credentialType == null;
        }
    }

    private static class PropertyConditions
    extends AllNestedConditions {
        public PropertyConditions() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.xsuaa", name={"disable-default-property-source"}, havingValue="false", matchIfMissing=true)
        static class DisableDefaultPropertySourceCondition {
            DisableDefaultPropertySourceCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.xsuaa", name={"multiple-bindings"}, havingValue="false", matchIfMissing=true)
        static class MultipleBindingsCondition {
            MultipleBindingsCondition() {
            }
        }
    }

    @Configuration
    @PropertySource(factory=XsuaaServicePropertySourceFactory.class, value={""})
    @Conditional(value={PropertyConditions.class})
    public static class XsuaaServiceAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={XsuaaServiceConfiguration.class})
        public XsuaaServiceConfiguration xsuaaServiceConfiguration() {
            LOGGER.info("auto-configures XsuaaServiceConfigurationDefault");
            return new XsuaaServiceConfigurationDefault();
        }

        @Bean
        public TokenUtil tokenUtil() {
            return new TokenUtil();
        }
    }
}

