/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.time.Instant;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;

public class TokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenUtil.class);
    private static final String EXTERNAL_ATTRIBUTE = "ext_attr";
    private static final String EXTERNAL_ATTRIBUTE_ENHANCER = "enhancer";

    static DecodedJwt decodeJwt(String encodedJwtToken) {
        return Base64JwtDecoder.getInstance().decode(encodedJwtToken);
    }

    static Jwt parseJwt(DecodedJwt decodedJwt) {
        JSONObject payload = new JSONObject(decodedJwt.getPayload());
        JSONObject header = new JSONObject(decodedJwt.getHeader());
        return new Jwt(decodedJwt.getEncodedToken(), Instant.ofEpochSecond(payload.optLong("iat")), Instant.ofEpochSecond(payload.getLong("exp")), header.toMap(), payload.toMap());
    }

    static boolean isXsuaaToken(DecodedJwt decodedJwt) {
        String jwtPayload = decodedJwt.getPayload().toLowerCase();
        return jwtPayload.contains(EXTERNAL_ATTRIBUTE) && jwtPayload.contains(EXTERNAL_ATTRIBUTE_ENHANCER) && jwtPayload.contains("xsuaa");
    }
}

