/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token;

import com.sap.cloud.security.xsuaa.extractor.AuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.token.Token;
import com.sap.cloud.security.xsuaa.token.TokenAuthenticationConverter;
import com.sap.cloud.security.xsuaa.token.authentication.XsuaaJwtDecoder;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.util.Assert;

public class SpringSecurityContext {
    private SpringSecurityContext() {
    }

    public static Token getToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AccessDeniedException("Access forbidden: not authenticated");
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Token) {
            return (Token)principal;
        }
        throw new AccessDeniedException("Access forbidden: SecurityContextHolder does not contain a principal of type 'Token' " + principal);
    }

    public static void init(String encodedJwtToken, JwtDecoder xsuaaJwtDecoder, AuthoritiesExtractor authoritiesExtractor) {
        Assert.isInstanceOf(XsuaaJwtDecoder.class, (Object)xsuaaJwtDecoder, (String)"Passed JwtDecoder instance must be of type 'XsuaaJwtDecoder'");
        Jwt jwtToken = xsuaaJwtDecoder.decode(encodedJwtToken);
        TokenAuthenticationConverter authenticationConverter = new TokenAuthenticationConverter(authoritiesExtractor);
        AbstractAuthenticationToken authentication = authenticationConverter.convert(jwtToken);
        SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    public static void clear() {
        SecurityContextHolder.clearContext();
    }
}

