/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token.authentication;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.authentication.PostValidationAction;
import com.sap.cloud.security.xsuaa.token.authentication.TokenInfoExtractor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import reactor.core.publisher.Mono;

public class ReactiveXsuaaJwtDecoder
implements ReactiveJwtDecoder {
    final Cache<String, ReactiveJwtDecoder> cache;
    private final List<OAuth2TokenValidator<Jwt>> tokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>();
    private final Collection<PostValidationAction> postValidationActions;
    private final TokenInfoExtractor tokenInfoExtractor;

    ReactiveXsuaaJwtDecoder(final XsuaaServiceConfiguration xsuaaServiceConfiguration, int cacheValidityInSeconds, int cacheSize, OAuth2TokenValidator<Jwt> tokenValidators, Collection<PostValidationAction> postValidationActions) {
        this.cache = Caffeine.newBuilder().expireAfterWrite((long)cacheValidityInSeconds, TimeUnit.SECONDS).maximumSize((long)cacheSize).build();
        this.tokenInfoExtractor = new TokenInfoExtractor(){

            @Override
            public String getJku(JWT jwt) {
                return new JSONObject(jwt.getHeader().toString()).optString("jku", null);
            }

            @Override
            public String getKid(JWT jwt) {
                return new JSONObject(jwt.getHeader().toString()).optString("kid", null);
            }

            @Override
            public String getUaaDomain(JWT jwt) {
                return xsuaaServiceConfiguration.getUaaDomain();
            }
        };
        this.tokenValidators.add(tokenValidators);
        this.postValidationActions = postValidationActions != null ? postValidationActions : Collections.emptyList();
    }

    public Mono<Jwt> decode(String token) throws JwtException {
        return Mono.just((Object)token).map(jwtToken -> {
            try {
                return JWTParser.parse((String)jwtToken);
            }
            catch (ParseException e) {
                throw new JwtException("Error initializing JWT decoder:" + e.getMessage());
            }
        }).map(jwtToken -> {
            String cacheKey = this.tokenInfoExtractor.getJku((JWT)jwtToken) + this.tokenInfoExtractor.getKid((JWT)jwtToken);
            return (ReactiveJwtDecoder)this.cache.get((Object)cacheKey, k -> this.getDecoder(this.tokenInfoExtractor.getJku((JWT)jwtToken)));
        }).flatMap(decoder -> decoder.decode(token)).doOnSuccess(jwt -> this.postValidationActions.forEach(act -> act.perform((Jwt)jwt)));
    }

    private ReactiveJwtDecoder getDecoder(String jku) {
        NimbusReactiveJwtDecoder decoder = new NimbusReactiveJwtDecoder(jku);
        decoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(this.tokenValidators));
        return decoder;
    }
}

