/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.extractor;

import com.sap.cloud.security.xsuaa.extractor.AuthoritiesExtractor;
import com.sap.cloud.security.xsuaa.token.XsuaaToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

public class DefaultAuthoritiesExtractor
extends JwtAuthenticationConverter
implements AuthoritiesExtractor {
    @Override
    public Collection<GrantedAuthority> getAuthorities(XsuaaToken jwt) {
        return this.extractAuthorities(jwt);
    }

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        List scopes = jwt.getClaimAsStringList("scope");
        if (scopes == null) {
            return Collections.emptyList();
        }
        return scopes.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

