/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.token.authentication;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.authentication.PostValidationAction;
import com.sap.cloud.security.xsuaa.token.authentication.ReactiveXsuaaJwtDecoder;
import com.sap.cloud.security.xsuaa.token.authentication.XsuaaAudienceValidator;
import com.sap.cloud.security.xsuaa.token.authentication.XsuaaJwtDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.web.client.RestOperations;

public class XsuaaJwtDecoderBuilder {
    int decoderCacheValidity;
    int decoderCacheSize;
    Collection<PostValidationAction> postValidationActions;
    private final XsuaaServiceConfiguration configuration;
    private RestOperations restOperations;
    private List<OAuth2TokenValidator<Jwt>> xsuaaTokenValidators;

    public XsuaaJwtDecoderBuilder(XsuaaServiceConfiguration configuration) {
        this.configuration = configuration;
        this.xsuaaTokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>();
        this.xsuaaTokenValidators.add(new XsuaaAudienceValidator(configuration));
        this.withDecoderCacheSize(100);
        this.withDecoderCacheTime(900);
    }

    public JwtDecoder build() {
        XsuaaJwtDecoder jwtDecoder = new XsuaaJwtDecoder(this.configuration, this.decoderCacheValidity, this.decoderCacheSize, (OAuth2TokenValidator<Jwt>)this.getValidators(), this.postValidationActions);
        Optional.ofNullable(this.restOperations).ifPresent(jwtDecoder::setRestOperations);
        return jwtDecoder;
    }

    public ReactiveJwtDecoder buildAsReactive() {
        return new ReactiveXsuaaJwtDecoder(this.configuration, this.decoderCacheValidity, this.decoderCacheSize, (OAuth2TokenValidator<Jwt>)this.getValidators(), this.postValidationActions);
    }

    private DelegatingOAuth2TokenValidator<Jwt> getValidators() {
        return new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new DelegatingOAuth2TokenValidator(this.xsuaaTokenValidators), new JwtTimestampValidator()});
    }

    public XsuaaJwtDecoderBuilder withDecoderCacheTime(int timeInSeconds) {
        this.decoderCacheValidity = timeInSeconds;
        return this;
    }

    public XsuaaJwtDecoderBuilder withDecoderCacheSize(int size) {
        this.decoderCacheSize = size;
        return this;
    }

    public XsuaaJwtDecoderBuilder withPostValidationActions(PostValidationAction ... postValidationActions) {
        this.postValidationActions = Arrays.asList(postValidationActions);
        return this;
    }

    public XsuaaJwtDecoderBuilder withTokenValidators(OAuth2TokenValidator<Jwt> ... tokenValidators) {
        this.xsuaaTokenValidators = Arrays.asList(tokenValidators);
        return this;
    }

    public XsuaaJwtDecoderBuilder withRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
        return this;
    }

    public XsuaaJwtDecoderBuilder withoutXsuaaAudienceValidator() {
        this.xsuaaTokenValidators = this.xsuaaTokenValidators.stream().filter(validator -> !(validator instanceof XsuaaAudienceValidator)).collect(Collectors.toList());
        return this;
    }
}

